DECLARE SUB DumpLine (Offset%, NumBytes%, FileNum%)
DECLARE SUB PrintHeader (FileNum AS INTEGER)
DECLARE SUB PrintBottom (FileNum AS INTEGER)
DEFINT A-Z

'-------------------------------------------
' DumpLine(Offset%, NumBytes%)
' Dump one line of bytes to the device file.
' Offset is the starting byte position, and
' NumBytes is the number of bytes to print.
'-------------------------------------------
SUB DumpLine (Offset, NumBytes, FileNum%)
  'Print the left edge
  PRINT #FileNum%, "   "; CHR$(186); " ";

  ' Hex Loop
  FOR I = 0 TO NumBytes - 1
    ch$ = HEX$(PEEK(Offset + I))
    IF LEN(ch$) = 1 THEN ch$ = "0" + ch$
    PRINT #FileNum%, ch$; " ";
  NEXT I

  ' Add Padding if necessary so separators will be aligned
  FOR I = 0 TO (48 - (NumBytes * 3)) - 1
    PRINT #FileNum%, " ";
  NEXT I
  PRINT #FileNum%, CHR$(179);

  ' ASCII Loop
  FOR I = 0 TO NumBytes - 1
    ch = PEEK(Offset + I)
    ' Filter out control chars and graphic chars
    IF (ch < 32) OR (ch > 127) THEN ch = ASC(".")
    PRINT #FileNum%, CHR$(ch);
  NEXT I

  ' Add padding if necessary so right edge will be aligned
  PRINT #FileNum%, SPACE$(16 - NumBytes);

  ' Print right edge
  PRINT #FileNum%, CHR$(186)
END SUB

'------------------------------------------------
' Print the bottom line of the variable dump box.
'------------------------------------------------
SUB PrintBottom (FileNum AS INTEGER)
  PRINT #FileNum%, "   "; CHR$(200); STRING$(49, 205); CHR$(207);
  PRINT #FileNum%, STRING$(16, 205); CHR$(188)
  ' The space is included for some printers that won't simply
  ' print a blank line.
  PRINT #FileNum%, " "
END SUB

'-------------------------------------------
'Print the Header for the variable dump box.
'-------------------------------------------
SUB PrintHeader (FileNum AS INTEGER)
  PRINT #FileNum%, "   "; CHR$(201); STRING$(49, 205);
  PRINT #FileNum%, CHR$(209); STRING$(16, 205); CHR$(187)
  PRINT #FileNum%, "   "; CHR$(186); " ";
  FOR I = 0 TO 15
    PRINT #FileNum%, "0"; HEX$(I); " ";
  NEXT I
  PRINT #FileNum%, CHR$(179);
  FOR I = 0 TO 15
    PRINT #FileNum%, HEX$(I);
  NEXT I
  PRINT #FileNum%, CHR$(186)
  PRINT #FileNum%, "   "; CHR$(199); STRING$(49, 196); CHR$(197);
  PRINT #FileNum%, STRING$(16, 196); CHR$(182)
END SUB

'------------------------------------------------------
' Sub VarDump(Target AS ANY, ItSize AS INTEGER)
'
' VarDump will provide a hex dump of ANY Variable.
' The display will consist of 16 lines of hex
' digits followed by a separator, and then 16 ASCII
' characters.
'
' Device$ is the target device and can be either
' a file name (watch it, duplicate files will be
' overwritten, there is no test to see if the file
' already exists!) or one of the following device
' names: SCRN: COMn: LPTn:
' where n is the number of the device for instance,
' COM2: or LPT1:
'
' Target is the Address of the Variable
' Use VARPTR to obtain the address of a User
' Defined variable, a Fixed Length String,
' any numeric variable, or a Dynamic String's
' String Descriptor. Use SADD to look at a
' Dynamic String.
'
' ItSize is the Size in bytes of the variable
' use Len(Target) to obtain the size in bytes of
' a User Defined Variable, or any string. Use
' 2 for an INTEGER, 4 for a LONG, 4 for Single
' Precision, 8 bytes for Double precision, and
' 4 for a String Descriptor.
'------------------------------------------------------
SUB VarDump (Device$, Target, ItSize AS INTEGER)
CONST True = -1, False = NOT True
  ' Full will indicate how many full lines to display
  ' LeftOver will indicate how many bytes are left over
  ' to be displayed on the last line.
  Full = ItSize \ 16
  LeftOver = ItSize MOD 16
  FileNum% = FREEFILE

  OPEN Device$ FOR OUTPUT AS #FileNum%

  ' Print the line of reference numbers and a separator line
  CALL PrintHeader(FileNum%)

  'Loop to display the full lines

  FOR I = 0 TO Full - 1
    CALL DumpLine((Target + (I * 16)), 16, FileNum%)
  NEXT I

  ' Loop to print leftover bytes
  IF LeftOver > 0 THEN
    CALL DumpLine((Target + (Full * 16)), LeftOver, FileNum%)
  END IF

  CALL PrintBottom(FileNum%)
  CLOSE 1
END SUB

