PROGRAM CapsLock;

USES
  Crt;

VAR
  Ch : char;

FUNCTION ReadChar : char;
{
  Replacement for ReadKey.
  Automatically flushes CapsLock whenever ShiftKey is hit.
}

VAR
  LocalCh : char;
  KeyStateByte : byte absolute $40:$17;      { status of shift keys }

BEGIN
  LocalCh := ReadKey;
  If KeyStateByte and 3 > 0 then             { if either shift then }
    begin
      LocalCh := UpCase (LocalCh);           { upcase ch }
      KeyStateByte := KeyStateByte and $BF;  { turn off capslock }
    end;
  ReadChar := LocalCh;                       { return char }
END;

BEGIN                                        { test program }
  Repeat
    Ch := ReadChar;
    Write (Ch)
  until
    Ch = #13;
END.
