heap=$600

CONSTANTS
 needsdos_cantreenter = $0005
 leftShift   	 = $0002           
 key_F2 	 = $3c
 swaptoems       = $8000
 swaptofile      = $4000

GLOBAL PREDICATES
%  from the TSR Library
 enableResident(string, integer) - (i, i) language c
 stayResident - language c
 enableSwap(integer, string, string, integer) - (i, i, i, o) language c
 installHotkey(integer, integer, integer, integer) - (i, i, i, i) language c
 setStatusHotKey(integer, string) - (i, i) language c
 setKeyboardSense(string) - (i) language c
 stuffBIOSKeys(string, integer) - (i, i) language c
 saveVideo(integer, integer, integer, integer ) - (i, i, o, o) language c
 wasGraphics - language c
% defined here but called by Library
 hotkey(integer) - (i)

DOMAINS
 dir		= vert(integer,integer); horiz(integer,integer)
 keyact		= clip; move(dir); size(dir)
 stringlist 	= string*
 paste_style 	= as_program ; as_comment 
 paren_control  = add_parens; no_parens

PREDICATES
 enable_best_swapping
 screen_read(integer, integer, integer, integer, string)
 getkeyAction(keyact)
 keyAct(char, integer,integer,integer,integer,integer,integer,keyact)
 keyAct2(char,integer, integer, integer, integer,keyact)
 reposition(keyact, integer,integer,integer,integer, 
 			integer,integer,integer,integer)
 delta(dir, integer,integer,integer,integer)
 legal(integer,integer,integer,integer)
 starting_width(integer,integer,integer,integer)
 scan_to_edge(integer,integer,integer,integer)
 is_skip_char(char)
 
 translate(string, string, paste_style)
 add_formatting(paste_style, string, string)
 parse(stringlist, string, paste_style)
 remove_extraneous(stringlist,stringlist)
 nondeterm  cdecl(stringlist,stringlist,string,string)
 nondeterm  cdecl1(stringlist,stringlist,string,string)
 nondeterm  cdecl2(stringlist,stringlist,string,string)
 cdims(stringlist,stringlist,string)	
 adecl(stringlist, string,string,string, paren_control) 
 mayParenthesize(paren_control, string,string,string,string)
 untokenize(stringlist, string)
 is_legal_type(stringlist,stringlist,string)
 modifier(stringlist,stringlist)
 may_start_with(stringlist,stringlist,stringlist)
 append(Stringlist,stringlist,stringlist)	
 member(string, stringlist)
 number(string)
 tokenize(String,stringlist)

CLAUSES
        hotKey(1) :- wasGraphics,!, fail.  
	hotKey(1) :-
		setStatusHotKey(1,off),
		textmode(Rows,ColsWide),
		saveVideo(Rows,ColsWide, CurrentRow,_),
		setkeyboardsense(on),
		starting_width(CurrentRow,ColsWide, StartCol, Wide),
		screen_read(CurrentRow,StartCol, 1, Wide, TextClipped),
		translate(TextClipped, NewText, PasteStyle),
		add_formatting(PasteStyle, NewText, TextToPaste),
		setStatusHotKey(1,on),
		stuffBiosKeys(TextToPaste, 0),!. % 0 => as fast as possible
	hotkey(1) :-
		makewindow(2,7,7,"", 2,5,3,20),
		write("can't parse this!"),	
		readchar(_),
		removewindow,
		setStatusHotKey(1,on).

	
	add_formatting(as_comment, Text, Paste) :- % home, cr, up
		format(Paste, "\255G\013\255H/*\n %s\n */", Text).
	add_formatting(as_program, Code, Paste) :- % home,dn,dn, cr,up,tab...
		format(Paste, "\255G\255P\255P\013\255H\t%s; \n\n", Code). 

	screen_read(R,C,H,W, Screen) :-
		makewindow(1,112,0,"",R,C,H,W,0,0,""),
		window_attr(112),
		getkeyAction(Action),
		reposition(Action, R,C,H,W, R2,C2,H2,W2),
		not(Action=clip), !,
		removewindow,
		screen_read(R2,C2,H2,W2, Screen).
	screen_read(_,_,_,_,SCR) :-
		window_str(Scr),
		removewindow.

	reposition(clip, Row,Col,High,Wide,Row,Col,High,Wide).
	reposition(move(Axis), Row,Col,High,Wide, Row2,Col2,High,Wide) :-
		delta(Axis, Row,Col,Row2,Col2).
	reposition(size(Axis), Row,Col,High,Wide, Row,Col,High2,Wide2) :-
		delta(Axis, High,Wide, High2,Wide2).
	
	delta(horiz(Amt, Limit), R, C, R, C2) :- legal(C,C2,Amt,Limit),!.
	delta(vert(Amt, Limit), R, C, R2, C) :-  legal(R,R2,Amt,Limit),!. 
	delta(_, R,C,R,C). 	% at limit, dont change 

	legal(Old,Value, Amt, OverLimit) :- Value=Old+Amt, Value<>OverLimit.
			
	getkeyAction(KeyAct):-	
		textmode(MaxRows,MaxCols),
		makewindow(_,_,_,_,Row, Col, High, Wide), % get current params
		readchar(Char),
		keyAct(Char,Row,Col,High,Wide, MaxRows, MaxCols,KeyAct).

	keyAct(0, R,C,_,_,Mr, Mc, KEY) :-
		readchar(Char),
		keyAct2(Char, R,C, Mr, Mc, Key).
       	keyAct(13,_,_,_,_,_,_,clip).
	keyAct('4',_,_,_,_,_,_,move(horiz(-1,-1))).
	keyAct('8',_,_,_,_,_,_,move(vert(-1,-1))).
	keyAct('6',_,_,_,Wide,_,MaxCols,move(horiz(1,Lim))):- 
		Lim = MaxCols - Wide + 1.
	keyAct('2',_,_,High,_,MaxRows,_,move(vert(1,Lim))):- 
		Lim = MaxRows - High + 1.
	
	keyAct2('K', _,_,_,_,size(horiz(-1,0))).
	keyAct2('H', _,_,_,_,size(vert(-1,0))).
	keyAct2('P', StartRow,_,MaxRows,_,size(vert(1,Lim))):- 
		Lim= MaxRows - StartRow + 1.  
	keyAct2('M', _,StartCol,_,MaxCols, size(horiz(1,Lim))):- 
		Lim=MaxCols - StartCol + 1.


	translate(Input, OutPut, ResultType):-
		upper_lower(Input, LowInput),
		tokenize(LowInput, Tokens),
		remove_extraneous(Tokens, RealTokens),
		parse(RealTokens, OutPut, ResultType).
	
	remove_extraneous(["/","*"|Rest],Result) :- 
		!, remove_extraneous(Rest, Result).
	remove_extraneous(Tokens, Result) :-
		append(Result, [";"], Tokens),!;
		append(Result, ["*","/"], Tokens),!.
	remove_extraneous(Same, Same).


	parse([declare,Name,as|Declaration], Result, as_program) :-
		adecl(Declaration, Pre, Post, Type, _),!,
		format(Result, "%s %s%s%s", Type, Pre, Name, Post).
  	parse([cast,Name,into|Declaration],Result, as_program) :-
		adecl(Declaration, Pre, Post, Type, _),!,
		format(Result, "(%s %s%s)%s", Type, Pre, Post, Name).
  	parse(Cexpr, Comment, as_comment) :-
		is_legal_type(Cexpr, Rest, Typestr),
		cdecl(Rest, Done, DecStr, Name), Done=[],!,
		format(Comment, "declare % as%s %s", Name, DecStr, Typestr).
	
	cdecl(["*","("|RDec], Rest, Dec, Name) :-
		cdecl(Rdec, R2, Dec1, Name),R2=[")"|Rest],
		format(Dec," pointer to%", Dec1).
  	cdecl(["*"|Rdec], Rest, Dec, Name) :- !,
		cdecl(Rdec, Rest, Dec1, Name), 
		format(Dec, "%s pointer to", Dec1).
  	cdecl(X, R, Dec, Name) :- cdecl1(X, R, Dec, Name).

  	cdecl1(X,R2, Dec, Name) :-
		cdecl2(X, R1, Dec2, Name), R1=["(",")"|R2],!,
		format(Dec, "%s function returning", Dec2).
  	cdecl1(X, Rest, Dec, Name) :-
		cdecl2(X, R2, Dec2, Name),
		cdims(R2,Rest, Dims),!,
		format(Dec, "%s array %s",Dec2, Dims).
	cdecl1(X,R,D,N) :- cdecl2(X,R,D,N).
	 
  	cdecl2(["(" | SubDec],  Rest, Dec, Name) :-
  		cdecl(SubDec, Rem,Dec, Name), Rem=[")"|Rest],!.
  	cdecl2([Name|Rest], Rest, "", Name).

  	cdims(["[","]"|R],R, "of"):-!.
  	cdims(["[", Number, "]"|R],R, Res) :- 
		number(Number),
		concat(Number," of",Res).
  
	adecl([function,"(",Name,")",returning|Decl],Left,Right,Type,add_parens) :-
		adecl(Decl,Left,Right1,Type, _),!,
		format(Right, "(%s)%s", Name, Right1).	
  	adecl([function,returning|Decl],Left,Right,Type,add_parens) :-
		adecl(Decl,Left,Right1,Type, _),!,
		concat("()", Right1, Right).
  	adecl([array,Number,of|Decl],Left,Right,Type,add_parens) :-
		number(Number),!,
		adecl(Decl, Left, Right1, Type, _),
		format(Right,"[%s]%s", Number, Right1).
  	adecl([array,of|Decl], Left, Right, Type,add_parens) :-
		adecl(Decl, Left,Right1,Type, _),!,
		format(Right, "[]%s", Right1).
  	adecl([pointer,to|Decl], Left, Right, Type, no_parens) :-!,
		adecl(Decl,Left1, Right1, Type, Parens),!,
		mayParenthesize(Parens, Left1, Right1, Left, Right).
  	adecl(Type, "","", Typestr,no_parens) :-
		is_legal_type(Type,[], TypeStr),!.

	mayParenthesize(add_parens, Left, Right, NewLeft, NewRight) :-!,
		concat(Left, "(*", NewLeft),
		concat(")",Right, NewRight). 
	mayParenthesize(no_parens,Left,Right, NewLeft,Right) :- 
		concat("*",Left,NewLeft).

  	is_legal_type(Input,Rest, TypeString) :-
		modifier(Input, R2),
		may_start_with(R2, [int,char,float,double,void],Rest),
		append(TypeList, Rest, Input),!,
		untokenize(TypeList, TypeString).	
  	is_legal_type([UnionStruct,Name|Rest],Rest, TypeStr) :-
		untokenize([UnionStruct,Name], TypeStr). % a bit loose...

  	modifier(X,Y) :-
		may_start_with(X, [unsigned], X2),
		may_start_with(X2, [short, long], Y).

  	may_start_with([X|Y],List, Y) :- member(X,List),!.
  	may_start_with(Y, _, Y).

  	member(X,[X|_]) :-!.
  	member(X,[_|Y]) :- 
		member(X,Y).
	
  	append([],X,X):-!.
 	append([X|Y], Z, [X|Z2]) :-
		append(Y,Z,Z2).

  	number(STR) :- str_int(STR,_).

	tokenize(String, Result) :-		
		fronttoken(String, Token, Rest), 
		member(Token, [a, an]),	     % ignore these as noise words
		!,tokenize(Rest, Result).
	tokenize(String, [Head|Tail]) :-
		fronttoken(String, Head, Rest),
		!,tokenize(Rest, Tail).
  	tokenize(_, []).

  	untokenize([X],X) :-!.
  	untokenize([H|T], Res) :-
		untokenize(T, RT),
		format(Res, "% %", H, RT).


	starting_width(Row, ColsWide, StartCol, Wide) :-
		makewindow(1, 7, 0, "", Row, 0, 1, ColsWide,0,0,""),
		LastCol = ColsWide-1,
		scan_to_edge(LastCol, 0,1, StartCol),
		scan_to_edge(LastCol, LastCol,-1,  EndCol),
		removewindow,
		Wide = EndCol + 1 - StartCol, 
		Wide > 1,!.
	starting_width( _, _, 0, 80).

	scan_to_edge(MaxCol, Col,Step, Edge) :-
		scr_char(0, Col, Char),
		is_skip_char(Char),
		C2 = Col + Step,
		C2>=0,C2<=MaxCol,
		!,scan_to_edge(MaxCol,C2, Step, Edge).
	scan_to_edge(_, Col, _, Col).

	is_skip_char(C) :- C<33,! ; C>127.
	
	enable_best_swapping :- enableSwap(swapToEms,"","",Stat), Stat=0,!.
	enable_best_swapping :- enableSwap(swapToFile,"","",Stat), Stat=0,!.
	enable_best_swapping.

GOAL
	enableResident("chelper",0), 	% id=prog name, no resident buffer
	enable_best_swapping,		
	installHotKey(1, key_f2, leftShift, needsDos_cantReenter),
	stayResident.

