heap = $2000

CONSTANTS
 needsdos_cantreenter = $0005
 swaptoems   	 = $8000
 swaptofile  	 = $4000
 kill_signal   	 = 0
 key_F10	 = $44
 leftShift       = $0002           

GLOBAL PREDICATES	
%  from the TSR library
 enableResident(string, integer) - (i, i) language c
 stayResident - language c
 enableSwap(integer, string, string, integer) - (i, i, i, o) language c
 installSignal(integer, integer) - (i, i) language c
 signal(integer) - (i)
 installHotkey(integer, integer, integer, integer) - (i, i, i, i) language c
 setStatusHotKey(integer, string) - (i, i) language c
 setKeyboardSense(string) - (i) language c
 saveVideo(integer, integer, integer, integer ) - (i, i, o, o) language c
 wasGraphics language C
%  defined here but called by the library
 hotkey(integer) - (i)

DATABASE
 determ file_is(string)
 determ file_buffer_position(string, integer)

PREDICATES
 pick_textmode(integer,integer)	
 best_Swap

GOAL	comline(Filename),
	existfile(Filename),
	asserta(file_is(Filename)),
	file_str(Filename, Buf),
	asserta(file_buffer_position(Buf, 0)),
	enableResident("pop_edit",0),
	best_Swap,
	installHotKey(1, key_F10, leftShift, needsDos_cantReenter),
	stayResident,!
	;
	write("must provide filename to edit").
CLAUSES
 	hotKey(1) :-
		setStatusHotKey(1,off),
		pick_textmode(Rows,Cols),
		saveVideo(Rows,Cols,_,_),
		makewindow(1, 7,7,"Pop-Edit", 0,0,Rows,Cols),
		retract(file_buffer_position(Buffer, Position)),
		setKeyboardSense(on),
		edit(Buffer,NewBuf,"","","",Position,"",1,1,1,1,NewPos,_),
		asserta(file_buffer_position(NewBuf, NewPos)),
		removewindow,
		setStatusHotKey(1,on).
		
	signal(kill_signal) :-
		file_buffer_position(Buf,_),
		file_is(Name),
		file_str(Name,Buf).

	pick_textmode(25,80) :- wasGraphics,!. 	    % was in a graphics mode
	pick_textmode(Rows,Cols) :- textmode(Rows,Cols).% use current mode

	best_Swap :- enableSwap(swapToEms, "","", Status),Status=0,!.
	best_Swap :- enableSwap(swapToFile, "poped.swp","", Status),
			Status=0,!.
	best_Swap.

		
