_TEXT   SEGMENT BYTE PUBLIC 'CODE'
_TEXT   ENDS
_DATA   SEGMENT BYTE PUBLIC 'DATA'
_DATA   ENDS

; Class BSS is uninitialized data.
_BSS    SEGMENT BYTE PUBLIC 'BSS'
_BSS    ENDS

; This segment is empty since all we need is its
; paragraph number.  By forcing it to align on a
; paragraph boundary, we safely skip any data that
; might be left in the last paragraph.
_EODATA SEGMENT PARA PUBLIC 'BSS'
_EODATA ENDS

_STACK  SEGMENT WORD PUBLIC 'STACK'
_STACK  ENDS

; Other segment declarations and grouping of
; segments other than those that are part of DGROUP.
. . .

; By the Microsoft segment ordering convention, the
; DGROUP group should always be at the end of the
; program.
DGROUP GROUP _DATA, ..., _BSS, _EODATA, _STACK, ...

_TEXT   SEGMENT

; Startup code, etc.
. . .

; Determine the segment address of next available
; paragraph.
; Segment address is returned in AX.
_EndPrg PROC
        mov     ax, _EODATA
        ret
_EndPrg ENDP

_TEXT   ENDS

; Other segment definitions.
        . . .

        END
