/* In the functions below, the bits are numbered from right */
/* to left. That is, the least significant bit is bit 0.    */

void setbit(unsigned *word, int n)
/* Sets bit in word */
{
  *word |= (1 << n);
}

void resetbit(unsigned *word, int n)
/* Clears bit in word */
{
  *word &= ~(1 << n);
}

void togglebit(unsigned *word, int n)
/* Toggles bit in word */
{
  *word ^= (1 << n);
}
