PROGRAM Bubbler;

CONST
  ARRAY_SIZE = 100;

TYPE
  IntArray = ARRAY[0..ARRAY_SIZE] OF INTEGER;

VAR
  I : Integer;
  TestArray : IntArray;

PROCEDURE Swap(VAR X : Integer; VAR Y : Integer);

VAR Temp : Integer;

BEGIN
  Temp := X;  { Store x's value in temp  }
  X := Y;     { Copy y's value into x    }
  Y := Temp;  { Copy x's value from temp into y }
END;


FUNCTION BubbleSort(VAR TargetArray : IntArray) : Integer;

VAR SortedFlag, PassFlag, I : Integer;

BEGIN
  SortedFlag := 1;
  REPEAT
    PassFlag := 1;
    FOR I := 0 TO ARRAY_SIZE DO
      IF (TargetArray[I] > TargetArray[I+1]) THEN
        BEGIN
          Swap(TargetArray[I],TargetArray[I+1]);
          SortedFlag := 0;
          PassFlag   := 0;
        END;
  UNTIL PassFlag = 1;
  BubbleSort := SortedFlag;
END;


PROCEDURE ShowArray(TargetArray : IntArray);

VAR I : Integer;

BEGIN
  FOR I := 0 TO ARRAY_SIZE DO
    BEGIN
      Write(TargetArray[I] : 3);
      IF ((I+1) MOD 20 = 0) THEN Writeln;
    END;
  Writeln;
END;


BEGIN
  FOR I := 0 TO ARRAY_SIZE DO
    TestArray[i] := Random(ARRAY_SIZE-1);
  Writeln('Here''s the unsorted array: ');
  ShowArray(TestArray);
  IF BubbleSort(TestArray) = 1
    THEN Writeln('That array was already sorted!')
  ELSE
    BEGIN
      Writeln;
      Writeln('The sort of the array is complete. Here it is:');
      ShowArray(TestArray);
    END;
END.