/**************************************************************************
*   MSG_PCKT.HPP - Listing 5
*   Written by Kevin D. Weeks, August 1990
*   Compiles and runs under Borland Turbo C++ and Zortech C++.
*/
#if !defined(MSG_PCKT_HPP)
#define MSG_PCKT_HPP
#include "serial.hpp"
// the following types are used to control file transfer between two
// devices.
enum Msg_Type
{
    NO_MESSAGE,         // used only as a response to get_msg_type()
    END_OF_PROCESS,     // designates end of load data or file process
    PROGRAM_INQUIRE,    // requests list of programs for upload
    LOAD_PROGRAM,       // requests that a program be uploaded
    DATA_INQUIRE,       // requests list of data files
    DATA_UPLOAD,        // requests that a data file be uploaded
    DATA_DOWNLOAD,      // requests that a data file be downloaded
    MSG_ERROR           // general error
};
// this structure is used to monitor internal object status
struct Msg_Status
{
    unsigned int    type_read : 1;
    unsigned int    size_read : 1;
    unsigned int    msg_read : 1;
};
struct Msg_Buffer
{
    Msg_Type        type;
    int             length;
    unsigned char   msg[1026];
};
class Msg_Packet : public Serial_Comm
{
  public:
    // constructors and destructor
            Msg_Packet(void);
            Msg_Packet(Com_Port port, Baud_Rate baud, Parity par,
                       Stop_Bits stop, Data_Bits data);
            ~Msg_Packet(void) {};
    // these methods provide support for the packet parameters. Note
    // that the original read() and write() methods in Serial_Comm
    // are still accessable.
    Result      read(Msg_Type *type, int *msg_size, void *buffer);
    Result      write(Msg_Type type, int msg_size, void *buffer);
    // the following methods replace their originals in Serial_Comm
    void        clr_recv_buffer(void);
    void        clr_send_buffer(void);
    // these methods are non-destructive (unlike the read() method).
    // in effect they allow the user to peek at what's in the buffer
    // without committing.
    Msg_Type    get_recv_msg_type(void);
    int         get_recv_msg_size(void);
    Result      get_recv_message(void *buffer);
    // the next three methods are also non-committal. nothing is
    // actually sent until send_message() is called.
    void        set_send_msg_type(Msg_Type type)
                { send_msg_buffer.type = type; };
    Result      set_send_msg_size(int size);
    void        set_send_message(void *buffer)
              {memcpy(send_msg_buffer.msg,buffer,get_buffer_size());};
    Result      send_message(void);
    int         get_timeout(void) { return timeout; };
    int         get_retrys(void) { return re_trys; };
    void        set_timeout(int tenths) { timeout = tenths; };
    void        set_retrys(int num_trys) { re_trys = num_trys; };
    // these three methods disable the base class' methods.
    // buffer_size is hard coded and input and output MUST take place
    // through the read() and write() methods above.
    Result      set_buffer_size(void) { return ERROR; };
    int         read_char(void) { return ERROR; };
    Result      write_char(void) { return ERROR; };
  private:
    Msg_Status      status;
    int             timeout;
    int             re_trys;
    Msg_Buffer      recv_msg_buffer;
    Msg_Buffer      send_msg_buffer;
};
#endif
