/**************************************************************************
*   SERIAL.HPP - Listing 1
*   Written by Kevin D. Weeks, August 1990
*   Compiles and runs under Borland Turbo C++ and Zortech C++.
*/
#if !defined(COMM_HPP)
#define COMM_HPP
// the following enum types perform two functions. first, they are checked
// for type by the compiler thus preventing an invalid parameter from
// being passed. second, they function as indices into the tables defined
// at the end of the class definition
enum Com_Port
    { Com_1, Com_2 };
enum Baud_Rate
    {   Baud_110, Baud_150, Baud_300, Baud_600, Baud_1200, Baud_2400,
        Baud_4800, Baud_9600 };
enum Parity
    { Odd_Parity, Even_Parity, No_Parity };
enum Stop_Bits
    {   Stop_Bits_1, Stop_Bits_2 };
enum Data_Bits
    {   Data_Bits_7, Data_Bits_8 };
enum Bool
    {   FALSE, TRUE };
enum Result
    {   OK, ERROR = -1 };
// define a hand-shaking function type
typedef   int(*HAND_SHAKE)(int);
// assembly function prototypes
extern "C"
{
    Result  com_open(int port, unsigned int paramters);
    void    com_close(void);
    int     com_read(void *buffer);
    Result  com_write(int num_bytes, void *buffer);
    int     com_read_char(void);
    Result  com_write_char(unsigned char chr);
    void    com_start_sending(void);
    void    com_stop_sending(void);
    unsigned int    com_get_status(void);
    int     com_chars_recvd(void);
    int     com_chars_sent(void);
    void    com_set_buffers(unsigned char *recv_buffer,
                            unsigned char *send_buffer, int length);
    void    com_set_handshake(HAND_SHAKE);
    void    com_clr_recv_buf(void);
    void    com_clr_send_buf(void);
};
// define the bit flags returned by com_get_status(). note that bits
// 0 - 3 indicate current status, 4 - 7 indicate line errors, and 8 -
// 10 indicate execution errors
typedef union
{
    unsigned int    value;
    struct
    {
        unsigned    port_open : 1;
        unsigned    char_received : 1;
        unsigned    sending_message : 1;
        unsigned    hand_shaking : 1;
        unsigned    overrun_err : 1;
        unsigned    parity_err : 1;
        unsigned    framing_err : 1;
        unsigned    break_received : 1;
        unsigned    buffer_overflow : 1;
        unsigned    invalid_port : 1;
        unsigned    port_not_found : 1;
    } flag;
} Comm_Status;
#define DEFAULT_BUF_SIZE    1024
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
*  the methods marked with a "// *" will automatically return an error
*  unless the port is owned by the current instance of the class    */
class Serial_Comm
{
  public:
    // constructors
        Serial_Comm(void);
        Serial_Comm(Com_Port port, Baud_Rate baud, Parity par,
                    Stop_Bits stop, Data_Bits data);
    // destructor
        ~Serial_Comm(void);
    // the first group of methods provide for actually accessing data
    // they will return an ERROR or -1 if the port is unowned or is
    // owned by another instance of the class.
    Result          open(void);
    void            close(void);
    int             read(void *client_buffer);
    Result          write(void *client_buffer, int length);
    int             read_char(void);
    Result          write_char(unsigned char);
    // the next two methods allow starting over. note that clr_send_
    // buffer will disable sending if sending is enabled. they will
    // return an ERROR if another instance owns the port
    Result          clr_recv_buffer(void);
    Result          clr_send_buffer(void);
    // get_status() returns a 0 if the port is owned by another.
    Comm_Status     get_status(void);
    // the next two methods return an ERROR if the port is owned
    // by another instance. in both caes 0 is a valid return value.
    int             get_bytes_recvd(void);
    int             get_bytes_sent(void);
    // all of the remaining methods will function whether the instance
    // in question owns the port or not.
    Com_Port        get_port(void) { return com_port; };
    Baud_Rate       get_baud_rate(void) { return baud_rate; };
    Parity          get_parity(void) { return parity; };
    Stop_Bits       get_stop_bits(void) { return stop_bits; };
    Data_Bits       get_data_bits(void) { return data_bits; };
    int             get_buffer_size(void) { return buffer_size; };
    // if the port is open AND owned by the particular instance called
    // then it will be closed before the parameters are changed and
    // then re-opened. since closing the port will cause anything in
    // the send or receive buffers to be discarded these methods
    // should be used carefully.
    void            set_port(Com_Port port);
    void            set_baud_rate(Baud_Rate baud);
    void            set_parity(Parity par);
    void            set_stop_bits(Stop_Bits stop);
    void            set_data_bits(Data_Bits data);
    Result          set_buffer_size(int size);
  protected:
  // the following attributes are shared by all instances of the class
  // and descendants.
    static Serial_Comm      *open_flag;
    static unsigned int     baud_table[8];
    static unsigned int     parity_table[3];
    static unsigned int     stop_table[2];
    static unsigned int     data_table[2];
  private:
  // all of these attributes are accessable through methods so keep
  // them private.
    int             buffer_size;
    unsigned char   *recv_buffer;
    unsigned char   *send_buffer;
    Com_Port        com_port;
    Baud_Rate       baud_rate;
    Parity          parity;
    Stop_Bits       stop_bits;
    Data_Bits       data_bits;
};
#endif
