#include <dos.h>
#include <stdio.h>
#include "swcasync.h"
#include "swcxym.h"
#include "swvideo.h"

#define TXQSIZE     (ULONG)2000
#define RXQSIZE     TXQSIZE
#define BAUDRATE    (ULONG)1200

void cleanup(void);

SWCCB *pPort;         /* functions, constants, prefixed by SW  */
SWCFILETRANSCB *ftb;  /* are those provided by SilverWare Inc. */

main()
{
int ch, status;  /* variables for character read, returned status */

  pPort = pPort=SWCOpenComm(COM1,RXQSIZE,TXQSIZE,0,&status);
  if(!pPort) {
    printf
    ("%s error from SWCOpenComm()\n",SWCErrorToText(status,0));
    exit(1);
  }
  SWCSetUART(pPort,BAUDRATE,SWPARITYNONE,8,1);
  atexit(cleanup);   /* cleanup routine executes at program end */

  while( 1 ) {       /* main program loop, repeat over and over */

    while (!SWCReceiveQueueEmpty(pPort))  /* if queue not empty */
    putch(SWCReceiveCharacter(pPort) & 0xff); /* char to screen */

    if (kbhit()) {      /* keyboard handler, execute if key hit */
      ch = getch();
      if (ch) SWCTransmitCharacter(pPort,ch); /* if <>0, send it */
      else switch (getch()) {  /* if 0, next char is a scan code */
        case 0x51:    /* if scan code = PgDn, do XMODEM download */
          ftb=SWCXYModemSetup(pPort,SWCXMODEM,SWCRECEIVE,
                              0,&status,"file");
          if(ftb) {
                SWCReceiveXMODEM(ftb);
                SWCFileTransferComplete(ftb);
          }
          else printf("%s error from SWCXYModemSetup()\n",
                    SWCErrorToText(status,0));
          break;
        case 0x2d:                     /* if scan code is Alt-X */
          exit(0);                     /* terminate the program */
      }
    }
  }
}

void cleanup(void)  /* cleanup executes when program terminates */
{
  SWCCloseComm(pPort,0); /* restore state of UART, int. vector */
}
