unit BaseObj;

{ Define a standard base object type for all other objects
  to derive from. }

interface

type BasePtr = ^Base;
     Base = object
       destructor Done; virtual;
       function ShallowClone: BasePtr;
       function DeepClone: BasePtr; virtual;
       function Clone: BasePtr; virtual;
       end;

implementation

destructor Base.Done;
  { Free the memory allocated to an object. }
  begin
  end;

function Base.ShallowClone: BasePtr;
  { Return a pointer to a shallow clone of Self. }
  var TempPtr: BasePtr;
  begin
  getmem(TempPtr,sizeof(self));
  move(self,TempPtr^,sizeof(self));
  ShallowClone := TempPtr
  end;

function Base.DeepClone: BasePtr;
  { Return a pointer to a deep clone of Self.
    Defaults to ShallowClone. }
  begin
  DeepClone := ShallowClone
  end;

function Base.Clone: BasePtr;
  { Return a pointer to a normal clone of Self.
    Defaults to ShallowClone. }
  begin
  Clone := ShallowClone
  end;

end.
