
// FILE.HPP : encapsulation of FILE* for ease and safety
#ifndef FILE_HPP_
#define FILE_HPP_
#include <stdio.h>
#include <stdlib.h>

class fileptr {
  FILE* filep;
public:
  fileptr(char * name, char * mode = "r") {
    filep = fopen(name, mode);
    if(!filep) {
      fprintf(stderr, "cannot open %s\n", name);
      exit(1);
    }
  }
  ~fileptr() { fclose(filep); }
  // automatic type conversion operator, so you can 
  // use a fileptr everywhere you use a FILE*:
  operator FILE*() { return filep; }
};

#endif FILE_HPP_
