#include <string.h>
#include <dos.h>

static char signature[] = "This is my signature.";

unsigned find_tsr_psp(void)
{
char i, ch, sig_size;
unsigned  mcb, owner, size, sig_addr, psp_addr = 0;

  sig_addr = 16 * (_DS - _CS) + 256 + (unsigned) &signature;
  sig_size = strlen(signature);  
  mcb = getmcb1();
  do {
    ch = peekb(mcb, 0);
    owner = peek(mcb, 1);
    size = peek(mcb, 3);
    if (mcb == owner-1) {              /* examine only psp blocks */
      for(i=0; i<sig_size; i++) {
        if (peekb(owner, sig_addr+i) != signature[i]) break;
        if (i == sig_size-1) psp_addr = owner;    /* if last char */
      }
    }
    mcb += (size + 1);
  } while (ch == 'M' && !psp_addr);
  return(psp_addr != _psp ? psp_addr : 0);
}
