unit Stacks;

{ Define two types of stack objects }

interface

uses BaseObj;

const MaxStackDepth = 10;

type StackPtr = ^Stack;
     Stack = object(Base)
       StackPointer: word;
       Data: array[1..MaxStackDepth] of BasePtr;
       constructor Init;
       function Empty: boolean;
       function Full: boolean;
       procedure Push(var Obj: Base); virtual;
       function Pop: BasePtr; virtual;
       function DeepClone: BasePtr; virtual;
       end;

type CloneStackPtr = ^CloneStack;
     CloneStack = object(Stack)
       constructor Init;
       destructor Done; virtual;
       procedure Push(var Obj: Base); virtual;
       end;

implementation

constructor Stack.Init;
  { Initialize a new Stack object. }
  begin
  StackPointer := 0
  end;

function Stack.Empty: boolean;
  { Check if the stack is currently empty. }
  begin
  Empty := StackPointer = 0
  end;

function Stack.Full: boolean;
  { Check if the stack is currently full. }
  begin
  Full := StackPointer = MaxStackDepth
  end;

procedure Stack.Push(var Obj: Base);
  { Push a pointer to an object onto the stack. }
  begin
  if not Full then
    begin
    inc(StackPointer);
    Data[StackPointer] := @Obj
    end
  end;

function Stack.Pop: BasePtr;
  { Pop a pointer to an object off of the stack. }
  begin
  if not Empty then
    begin
    Pop := Data[StackPointer];
    dec(StackPointer)
    end
  end;

function Stack.DeepClone: BasePtr;
  { Return a pointer to a deep clone of a stack. }
  var I: word;
      TempPtr: BasePtr;
  begin
  TempPtr := Base.DeepClone;
  for I := 1 to StackPointer do
    Data[I] := Data[I]^.DeepClone;
  DeepClone := TempPtr
  end;

constructor CloneStack.Init;
  { Initialize a new CloneStack object. }
  begin
  Stack.Init
  end;

destructor CloneStack.Done;
  { Free the memory allocated to a CloneStack and its contents. }
  var I: word;
  begin
  for I := 1 to StackPointer do
    Data[I]^.Done;
  Stack.Done
  end;

procedure CloneStack.Push(var Obj: Base);
  { Push a clone of an object onto the stack. }
  var TempPtr: BasePtr;
  begin
  if not Full then
    begin
    TempPtr := Obj.Clone;
    Stack.Push(TempPtr^)
    end
  end;

end.
