#include <string.h>                        
#include <stdio.h>
#include <stdlib.h>
#include <values.h>
#include <typesall.h>


///////Code for the value classes
//The code for each function is kept in parallel so we can
//take advantage of the symmetry across the types

//Constructors
char* invalid="invalid";//Address used for <namptr> to indicate error
value::value(){namptr=NULL;}
value::value(char* namestr){
	namptr=namestr? strdup(namestr):NULL;
	if(!namptr) namptr=invalid;}
ival::ival(char* namestr, int val):value(namestr){data=val;}
lval::lval(char* namestr, long val):value(namestr){data=val;}
fval::fval(char* namestr, float val):value(namestr){data=val;}
dval::dval(char* namestr, double val):value(namestr){data=val;}
ldval::ldval(char* namestr, long double val):value(namestr){data=val;}
sval::sval(char* namestr, char* val):value(namestr){
	data=val? strdup(val):NULL; 
	if(!data) namptr=invalid;}

//destructors
value::~value(){if(namptr!=invalid) delete namptr;}
sval::~sval(){delete data;}

//characteristics
value::valid(){return namptr!=invalid;}//compare address, NOT string

datatype value::type(){return EMPTY;}
datatype ival::type(){return INT;}
datatype lval::type(){return LONG;}
datatype fval::type(){return FLOAT;}
datatype dval::type(){return DOUBLE;}
datatype ldval::type(){return LDOUBLE;}
datatype sval::type(){return STRING;}

const char* value::typename(){return "EMPTY";}
const char* ival::typename(){return "INT";}
const char* lval::typename(){return "LONG";}
const char* fval::typename(){return "FLOAT";}
const char* dval::typename(){return "DOUBLE";}
const char* ldval::typename(){return "LDOUBLE";}
const char* sval::typename(){return "STRING";}

//overloaded functions required for tests below
inline long absval(long D){return (D>=0)? D:-D;}
inline float absval(float D){return (D>=0)? D:-D;}
inline double absval(double D){return (D>=0)? D:-D;}
inline long double absval(long double D){return (D>=0)? D:-D;}

//return value as specified variable type
//signed integer - returns zero if conversion not possible
int value::asint(){return 0;};
int ival::asint(){return data;}
int lval::asint(){return (absval(data)<=MAXINT)?data:0;}
int fval::asint(){return (absval(data)<=MAXINT)?data:0;}
int dval::asint(){return (absval(data)<=MAXINT)?data:0;}
int ldval::asint(){return (absval(data)<=MAXINT)?data:0;}
int sval::asint(){return atoi(data);}

//signed long - returns zero if conversion not possible
long value::aslong(){return 0;};
long ival::aslong(){return data;}
long lval::aslong(){return data;}
long fval::aslong(){return (absval(data)<=MAXLONG)?data:0;}
long dval::aslong(){return (absval(data)<=MAXLONG)?data:0;}
long ldval::aslong(){return (absval(data)<=MAXLONG)?data:0;}
long sval::aslong(){return atol(data);}

//range evaluation functions to check whether conversions will "fit"
inline int floatsize(double D){
	double absD=absval(D); return absD<MAXFLOAT && absD>MINFLOAT;}
inline int floatsize(long double D){
	long double absD=absval(D); return absD<=MAXFLOAT && absD>=MINFLOAT;}
inline int doublesize(long double D){
	long double absD=absval(D); return (absD<=MAXDOUBLE && absD>=MINDOUBLE);}

//float - returns zero if conversion not possible
float value::asfloat(){return 0;};
float ival::asfloat(){return data;}
float lval::asfloat(){return data;}
float fval::asfloat(){return data;}
float dval::asfloat(){return floatsize(data)? data:0;}
float ldval::asfloat(){return floatsize(data)? data:0;}
float sval::asfloat(){float dbuf=atof(data);	return floatsize(dbuf)? dbuf:0;}

//double - returns zero if conversion not possible
double value::asdouble(){return 0;};
double ival::asdouble(){return data;}
double lval::asdouble(){return data;}
double fval::asdouble(){return data;}
double dval::asdouble(){return data;}
double ldval::asdouble(){return doublesize(data)? data:0;}
double sval::asdouble(){return atof(data);}

//long double - returns zero if conversion not possible
long double value::asldouble(){return 0;};
long double ival::asldouble(){return data;}
long double lval::asldouble(){return data;}
long double fval::asldouble(){return data;}
long double dval::asldouble(){return data;}
long double ldval::asldouble(){return data;}
long double sval::asldouble(){
	long double dbuf; 
	int valid=sscanf(data,"%Lg",&dbuf);	
	return valid? dbuf:0;}

//string - re-uses same buffer at each call
static char valbuf[40];
const char* value::asstring(){return typename();}
const char* ival::asstring(){return itoa(data,valbuf,10);}
const char* lval::asstring(){return ltoa(data,valbuf,10);}
const char* fval::asstring(){sprintf(valbuf,"%9.7g",data); return valbuf;}
const char* dval::asstring(){sprintf(valbuf,"%17.15lg",data); return valbuf;}
const char* ldval::asstring(){sprintf(valbuf,"%21.19Lg",data); return valbuf;}
const char* sval::asstring(){return data;}
