// ==========================================================
// Listing 3: demo.cpp
// C++ code for demonstration of Heap class.
// Copyright (C) 1991 by Nicholas Wilt.  All rights reserved.
// ==========================================================
// Refer to the MAKEFILE listing (Listing 4) for dependencies
// ----------------------------------------------------------

#include <iostream.h>
#include "heap.h"

// ------------------------------------------------------
// This is the comparison function for ASCENDING integers
// ------------------------------------------------------
int comp_ints(void *a, void *b)
{
  return( *((int *) a) - *((int *) b));
}

// ---------------------------------------------------------
// This is the comparison function for DESCENDING characters
// ---------------------------------------------------------
int comp_char(void *a, void *b)
{
  return( *((char *) b) - *((char *) a));
}

// ==============================================================
main()
{
  // An unordered set of integers
  int numbers[20] = {1, 2, 4, 5, 3,
		     	19, 15, 18, 0, 13,
		     	11, 14, 12, 16, 17,
		     	6, 9, 8, 7, 10};

  // An unordered set of characters
  char letters[34] = {"THEQUICKBROWNFOXJUMPSOVERLAZYDOGS"};
                    // 123456789012345678901234567890123

  Heap h(comp_ints);  // A heap instance for the integers
  Heap ch(comp_char); // A heap instance for the characters

  int i;

// --------------------------------------------------------
// Start with the integer data...
// --------------------------------------------------------
  // Print out numbers before sorting
  for (i = 0; i < 20; i++)
    cout << numbers[i] << ' ';
  cout << '\n';

  // Insert numbers into heap
  for (i = 0; i < 20; i++)
    h.Insert(numbers+i);

  // Print out numbers in order extracted from heap
  // (In this case, in ASCENDING order.)
  for (i = 0; i < 20; i++)
    cout << *((int *) h.Extract()) << ' ';
  cout << '\n';

// --------------------------------------------------------------
// Now, try the character data...
// --------------------------------------------------------------

  // Print out letters before sorting
  for (i = 0; i < 33; i++)
    cout << letters[i] << ' ';
  cout << '\n';

  // Insert letters into heap
  for (i = 0; i < 33; i++)
    ch.Insert(letters+i);

  // Print out letters in order extracted from heap
  // (In this case, in DESCENDING order.)
  for (i = 0; i < 33; i++)
    cout << *((char *) ch.Extract()) << ' ';
  cout << '\n';

}
