/* shelldos.c -- function to execute DOS shell. */
#define TESTING		/* comment if putting in library */
#include <process.h>
#include <stdlib.h>
#include <errno.h>

int ShellToDOS (char *Prompt) {
    char *Comspec = getenv ("COMSPEC");

    /* If no COMSPEC defined then report error and exit */
    if (Comspec == NULL) {
	errno = ENOENT;
	return -1;
    }

    if (putenv (Prompt)) {  /* Set the new PROMPT string */
	errno = ENOMEM;
	return -1;
    }

    /* Attempt to start the command processor. */
    return spawnl (P_WAIT, Comspec, NULL);
}

#ifdef TESTING
#include <stdio.h>
/* The message to be displayed at the DOS prompt */
static char *Message =
    "PROMPT=Type EXIT to return to program $_$P$G";

void main (void) {
    if (ShellToDOS (Message) == -1)
	perror ("ERROR executing DOS shell");
}
#endif
