// This code is public domain. 
 
// Get prototypes for inport and outport functions. 
#include <dos.h> 
 
typedef unsigned char byte; 
typedef unsigned short word; 
 
// Byte port. 
class bytePort { 
  word _addr;   // Port address. 
 
  public: 
 
  // Constructors and destructor. 
  bytePort(word addr) : _addr(addr) { } 
  bytePort(const bytePort &p) : _addr(p._addr) { } 
  bytePort() { } 
  ~bytePort() { } 
 
  // Set port address. 
  void addr(word addr) { 
  _addr = addr; 
  } 
 
  // Get port address. 
  word addr() const { 
  return _addr; 
  } 
 
  // Read byte value from port. 
  operator byte() const { 
  return inportb(_addr); 
  } 
 
  // Write byte value to port. 
  bytePort& operator=(byte value) const { 
  outportb(_addr, value); 
  return *this; 
  } 
 
  // Set bits at port. 
  bytePort& operator|=(byte value) const { 
  outportb(_addr, inportb(_addr) | value); 
  return *this; 
  } 
 
  // Mask bits at port. 
  bytePort& operator&=(byte value) const { 
  outportb(_addr, inportb(_addr) & value); 
  return *this; 
  } 
 
  // Toggle bits at port. 
  bytePort& operator^=(byte value) const { 
  outportb(_addr, inportb(_addr) ^ value); 
  return *this; 
  } 
 
  // Copy value from one port to another. 
  bytePort& operator=(const bytePort& p) const { 
  outportb(_addr, inportb(p._addr)); 
  return *this; 
  } 
 
  // Treat port as base of an array of ports. 
  bytePort operator[](int index) const { 
  return _addr + index; 
  } 
  }; 
