#pragma option -k-  // Disable stack from if not needed
#pragma option -O   // Eliminate redundant jumps(to self etc...)

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <string.h>

#define ERROR -1
typedef unsigned int uint;
typedef unsigned char uchar;

int 		redirected();
uint 		get_key();
char 		*dump(uint offset,uint segment);
void 		next_page();

main()
{
	int redirection = redirected(), i, j;
	if(!redirection) clrscr();
	printf("ͻ\n");
	printf(" Video Information      Bios Dump C000-C0FF \n");
	printf("͹\n");
	for(i = j = 0;i < 20;i++,j += 8)
		printf(" %s \n",dump(0xc000,uint(j)));
	if(!redirection) next_page();
	for(;j < 256;j += 8)
		printf(" %s \n",dump(0xc000,uint(j)));
	printf("ͼ\n");
	if(!redirection) {
		printf(" Press any key to continue... ");
		get_key(); clrscr();
	}
}

void next_page()
{
	printf("ͼ\n");
	printf(" Press any key to continue... ");
	get_key(); clrscr();
	printf("ͻ\n");
}

char *dump(uint offset,uint segment)
{
	int   i;
	uchar far *ptr = (uchar far *)MK_FP(offset,segment);
	static char string[80];
	uchar   c;
	char    trailer[40], temp[40];

	sprintf(string,"%04X:%04X ",offset,segment);
	trailer[0] = temp[0] = 0;
	for(i = 0;i < 8;i++) {
		c = *ptr++;
		sprintf(temp,"%02x ",c);
		strcat(string,temp);
		if(c < ' ' || c > 126) temp[0] = '.';
		else                   temp[0] = c;
		temp[1] = 0;
		strcat(trailer,temp);
	}
	strcat(string,trailer);
	return string;
}

uint get_key()
{
	asm {
		xor	ah,ah
		int	0x16
	}
	return _AX;
}

int redirected()
{
   asm {
     push	ds
     mov	ax,_psp         // Get segment of PSP
     mov	ds,ax           // Put it in DS
     xor	bx,bx           // Zero out BX
     les     bx,[bx + 0x34]  // Move table adr. at DS:BX to ES & BX
     mov     al,es:[bx]	// stdin normally = 1(i.e. CON)
     mov	ah,es:[bx + 1]	// stdout normally = 1(i.e. CON)
     pop	ds
     cmp	al,ah           // Compare the two handles
     mov	ax,1            // Return 1 if not equal
     jne	EXIT
     xor	ax,ax           // Clear to 0 AX if equal
   }
EXIT:
	return _AX;
}
