PROGRAM DesqTest;

uses Dos { for MsDos procedure };

var
  Reg : Registers;  { Registers is defined in the Dos unit }

const
  DESQview : boolean = false;

begin
  { See if DESQview is active. }
  Reg.CX := $4445;  { Put 'DESQ' into CX-DX so that }
  Reg.DX := $5351;  { DESQview will process this call. }
  Reg.AX := $2B01;  { DESQview uses DOS' set date function. }
  MsDos(Reg);    { This procedure does a DOS Interrupt $21. }
  { If no $FF error code is returned, DESQview trapped and
    processed the interrupt before it could get to DOS. }
  If Reg.AL <> $FF then
  begin
    WriteLn ('DESQview is running');
    { BX contains DESQview version, for example "2.26". }
    WriteLn ('BH=',Reg.BH,', BL=',Reg.BL,
               ', DESQview version is ',Reg.BH,'.',Reg.BL);
    DESQview := true;  { Use this value at any later time. }
  end;
  { Discard the remainder of this time slice. }
  If DESQview then InLine (
    $50/       { PUSH AX       ; Save whatever is currently
                                   in AX }
    $B8/$101A/ { MOV  AX,101Ah ; Function: switch to
                                   DESQview's stack }
    $CD/$15/   { INT  15h      ;  Make the call }
    $B8/$1000/ { MOV  AX,1000h ; Function: discard remaining
                                   time slice }
    $CD/$15/   { INT  15h      ;  Make the call }
    $B8/$1025/ { MOV  AX,1025h ; Function: switch from
                                   DESQview's stack }
    $CD/$15/   { INT  15h      ;  Make the call }
    $58);      { POP  AX       ; Restore AX }
end.
