CSeg    segment
assume  cs:CSeg,ds:CSeg,es:nothing
        org     100h
Begin:  mov     ah,2ah  ; Get the system date.
        int     21h
; DH=Month; DL=Day; AL=Day-of-week (Sun=0 etc.).
        add     al,24   ; For last Sun check.
        cmp     dh,4    ; Check for April.
        jl      Exit00  ; Standard time.
        je      AprCK   ; It's April, check Sun.
OcbCK:  cmp     dh,10   ; Check for October.
        jg      Exit00  ; Standard time.
        jl      Bump    ; Daylight savings.
        xchg    dl,al   ; Swap compare for October.
AprCK:  cmp     dl,al   ; Last Sunday check.
        jl      Exit00  ; Standard time.
; Adjust for daylight savings time here.
Bump:   mov     ax,40h  ; Bump system time ahead
        mov     es,ax   ;  65543 counts (1 hour).
        cli             ; Do the deed without ticks.
        add     word ptr es:[6ch],7
        adc     word ptr es:[6eh],1
; Check for 24 hour rollover.
        cmp     word ptr es:[6eh],24
        jl      Exit00
        cmp     word ptr es:[6ch],168
        jb      Exit00
; Set the overflow and rollover the counts.
        mov     byte ptr es:[70h],1
        sub     word ptr es:[6ch],168
        mov     word ptr es:[6eh],0
Exit00: int     20h
CSeg    ends
        end     Begin