#include <alloc.h>
#include <iostream.h>

#define TABLE_SIZE  100

static void *validaddr[TABLE_SIZE];

///
// Call C malloc() function and save pointer in internal table.
void *operator new(size_t s)
{
void *p = malloc(s);

// Search for free space in table.
for (int i = 0; i < TABLE_SIZE && validaddr[i] != 0; i++);

// Insert pointer into table if space found.
if (i != TABLE_SIZE)
  validaddr[i] = p;

return (p);
}

///
// Test pointer for validity before deleting it.
void operator delete(void *p)
{
if (p)
  {
  for (int i = 0; i < TABLE_SIZE && p != validaddr[i]; i++);
  if (i != TABLE_SIZE)
    {
    validaddr[i] = 0;
    free(p);
    }
  else
    // *** SET BREAKPOINT HERE ***
    cerr << "MEM MGR ERROR: delete called with invalid pointer "
    << p << '.' << endl;   }
}
