
{$IFDEF Windows}
uses WinCrt; {to allow WriteLn under Windows}
{$ENDIF}

const
  Digits : array[0..$F] of Char = '0123456789ABCDEF';

  function HexW(W : Word) : string;
    {-Return hex string for word}
  begin
    HexW[0] := #4;
    HexW[1] := Digits[hi(W) shr 4];
    HexW[2] := Digits[hi(W) and $F];
    HexW[3] := Digits[lo(W) shr 4];
    HexW[4] := Digits[lo(W) and $F];
  end;

  function HexPtr(P : Pointer) : string;
    {-Return hex string for pointer}
  begin
    HexPtr := HexW(Seg(P^))+':'+HexW(Ofs(P^));
  end;

const
  GraphicsRam = Ptr($A000, $0000);

begin
  WriteLn(HexPtr(GraphicsRam));
end.
