// Listing 3: sets.cpp
// Test program for BitVect (bit vector) class.
// Copyright (C) 1991 by Nicholas Wilt.

#include <iostream.h>
#include <stdlib.h>
#include <alloc.h>

#include "bitvect.h"

// This program uses bit vectors to implement sets of characters.
// The CapitalLetters function returns a 256-element bit vector
// with the bits corresponding to capital letters set.
// LowercaseLetters returns a 256-element bit vector with the bits
// corresponding to lowercase letters set.

BitVect CapitalLetters()
{
  BitVect ret(256, 0);
  ret.SetRange((long) 'A', (long) 'Z', 1);
  return ret;
}

BitVect LowercaseLetters()
{
  BitVect ret(256, 0);
  ret.SetRange((long) 'a', (long) 'z', 1);
  return ret;
}

BitVect Vowels()
{
  BitVect ret(256, 0);
  ret.SetBit((long) 'a', 1);    ret.SetBit((long) 'A', 1);
  ret.SetBit((long) 'e', 1);    ret.SetBit((long) 'E', 1);
  ret.SetBit((long) 'i', 1);    ret.SetBit((long) 'I', 1);
  ret.SetBit((long) 'o', 1);    ret.SetBit((long) 'O', 1);
  ret.SetBit((long) 'u', 1);    ret.SetBit((long) 'U', 1);
  return ret;
}

// Given a string and a bit vector, prints out only
// only the characters in the string that are members
// of the set described by the bit vector.
void
PrintString(unsigned char *s, BitVect& x)
{
  while (*s) {
    if (x[*s])
      cout << *s;
    s++;
  }
  cout << '\n';
}

int main()
{
  char *StringToLookAt = "([StringToLookAt])";

  BitVect iscapital = CapitalLetters();
  BitVect islowercase = LowercaseLetters();
  BitVect iseither = iscapital | islowercase;
  BitVect isneither = ~iseither;
  BitVect isvowel = Vowels();
  BitVect isconsonant = iseither - isvowel;

  cout << "String to look at: " << StringToLookAt << '\n';

  cout << "Capitals only: ";
  PrintString((unsigned char *) StringToLookAt, iscapital);

  cout << "Lowercase only: ";
  PrintString((unsigned char *) StringToLookAt, islowercase);

  cout << "Capitals or lowercase: ";
  PrintString((unsigned char *) StringToLookAt, iseither);

  cout << "Neither capitals nor lowercase: ";
  PrintString((unsigned char *) StringToLookAt, isneither);

  cout << "Vowels only: ";
  PrintString((unsigned char *) StringToLookAt, isvowel);

  cout << "Consonants only: ";
  PrintString((unsigned char *) StringToLookAt, isconsonant);

  return 0;
}
