UNIT ExtKey;                                { Author: Ron Aaron }
{===============================================================}
{ Implements the low-level keyboard handler needed to support   }
{ extended keyboards, and a replacement for Drivers.GetKeyEvent.}
{ This unit is hereby put in the public domain by its author,   }
{===============================================================}
INTERFACE
USES Drivers;
CONST
{---------------------------------------------------------------}
{ ExtKeyBoardInstalled : Set TRUE by unit initialization code   }
{                        if an enhanced keyboard was detected.  }
{---------------------------------------------------------------}
  ExtKeyBoardInstalled : BOOLEAN = FALSE;
{---------------------------------------------------------------}
{ Set to True if you don't want to distinguish the 'PAD' keys.  }
{---------------------------------------------------------------}
  FilterDuplicateKeys  : BOOLEAN = FALSE;
{---------------------------------------------------------------}
{ Extended Keyboard constants. Not an exhaustive list, however! }
{---------------------------------------------------------------}
   kbF11       = $8500;      kbF12        = $8600;
   kbAltF11    = $8B00;      kbAltF12     = $8C00;
   kbCtrlF11   = $8900;      kbCtrlF12    = $8A00;
   kbShiftF11  = $8700;      kbShiftF12   = $8800;
   kbCtrlUp    = $8DE0;      kbCtrlDn     = $91E0;
   kbPadCtrlUp = $8D00;      kbPadCtrDn   = $9100;
   kbAltUp     = $9800;      kbAltDn      = $A000;
{---------------------------------------------------------------}
{ Public declaration so we can use this proc elsewhere.         }
{ Same heading as the equivalent in DRIVERS.TPU.                }
{---------------------------------------------------------------}
PROCEDURE GetKeyEvent(VAR Event: TEvent);
{===============================================================}
IMPLEMENTATION

CONST
{---------------------------------------------------------------}
{ Default INT 16h function numbers, for use with older, 84-key  }
{ keyboards.  The unit initialization logic will reset these for}
{ an enhanced keyboard if one is detected.                      }
{---------------------------------------------------------------}
  QueryKeybd : Byte = $01;
  ReadKeybd  : Byte = $00;
{===============================================================}
FUNCTION GetExtKey : Word; ASSEMBLER;
{---------------------------------------------------------------}
{ Reads extended keyboard and returns SCAN/CHAR code.           }
{ Returns 0 IF no key is available.                             }
{ Uses ASSEMBLER function to eliminate overhead associated with }
{ normal Pascal calls.                                          }
{---------------------------------------------------------------}
ASM
  mov ah, QueryKeybd          { 00h for 84-key; 10h for 101-key }
  int 16h
  mov ax, 0
  jz  @@out
  mov ah, ReadKeybd           { 01h for 84-key; 11h for 101-key }
  int 16h
@@out:
END;
{===============================================================}
PROCEDURE GetKeyEvent(VAR Event : TEvent );
{---------------------------------------------------------------}
{ Similar to DRIVERS.GetKeyEvent, except:                       }
{   1) Knows about enhanced keyboards                           }
{   2) Can eliminate 'duplicate' key codes                      }
{---------------------------------------------------------------}
BEGIN
  Event.KeyCode := GetExtKey;
  IF Event.KeyCode <> 0 THEN BEGIN
    Event.What := evKeyDown;
    IF (FilterDuplicateKeys AND (Event.KeyCode AND $00FF = $00E0))
    THEN
      Event.KeyCode := Event.KeyCode AND $FF00;
  END
  ELSE
    Event.What := evNothing;    { Don't assume it was evNothing!}
END;
{================================================================}
FUNCTION IsExtKeyboard : Boolean; ASSEMBLER;
{----------------------------------------------------------------}
{ Uses a BIOS vendor's recommended method for ascertaining       }
{ whether an enhanced keyboard is installed.                     }
{ (May not work on EVERY machine/keyboard combination.)          }
{          Refer also to the comments in the text.               }
{----------------------------------------------------------------}
CONST
  BogusKey = $FEDC;

ASM
@@flush_it:                 { (1) Flush all keys from kbd buffer }
   mov  ah, 1                          { Is there a key waiting? }
   int  16h
   jz   @@flush_done                              { NO--continue }
   mov  ah, 0                            { YES--Read waiting key }
   int  16h
   jmp  @@flush_it                            { Loop until done! }
@@flush_done:
   mov  ah, 5               { (2) Load a dummy key in the buffer }
   mov  cx, BogusKey
   int  16h
   jc   @@noext             { (3a) Stuff failed, NOT an ext. kbd }
   or   al, al
   jnz  @@noext             { (3b) Stuff failed, NOT an ext. kbd }
   mov  ah, 10h             { (4) Now try to read back character }
   int  16h
   cmp  ax, BogusKey
   jne  @@noext              { (5a) Read failed, NOT an ext. kbd }
   mov  ax, 1               { (5b) Succeeded! It IS an ext. kbd! }
   jmp  @@done
@@noext:
   xor  ax, ax
@@done:
END;
{===============================================================}
{       U N I T   I N I T I A L I Z A T I O N   L O G I C       }
{===============================================================}
{ If this unit is used, the logic tests for an enhanced         }
{ keyboard, and if found, sets up the appropriate BIOS INT 16h  }
{ functions.                                                    }
{---------------------------------------------------------------}
BEGIN
  IF IsExtKeyBoard THEN BEGIN
    ExtKeyBoardInstalled := TRUE;
    QueryKeybd := $11;             { Extended Query Keyb'd code }
    ReadKeybd  := $10;              { Extended Read Keyb'd code }
  END;
END.
