//  OSKETCH.CPP by Tom Swan

#include <owl.h>
#include "osketch.h"

class TSketchApp: public TApplication
{
public:
  TSketchApp(LPSTR aName, HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpCmd, int nCmdShow) : TApplication(aName, hInstance,
    hPrevInstance, lpCmd, nCmdShow) {};
  virtual void InitMainWindow();
};

_CLASSDEF(TSketchWin)
class TSketchWin: public TWindow
{
public:
  HDC dc;          // Handle to display context
  BOOL dragging;   // True if clicking and dragging mouse
  TSketchWin(PTWindowsObject AParent, LPSTR ATitle);
  virtual void IDMErase(RTMessage)
    = [CM_FIRST + IDM_ERASE];
  virtual void IDMExit(RTMessage)
    = [CM_FIRST + IDM_EXIT];
  virtual void WMLButtonDown(RTMessage Msg)
    = [WM_FIRST + WM_LBUTTONDOWN];
  virtual void WMMouseMove(RTMessage Msg)
    = [WM_FIRST + WM_MOUSEMOVE];
  virtual void WMLButtonUp(RTMessage)
    = [WM_FIRST + WM_LBUTTONUP];
};


// Initialize TSketchApp's main window
void TSketchApp::InitMainWindow()
{
  MainWindow = new TSketchWin(NULL, "ObjectWindows Sketch");
}

// Initialize the application's main window
TSketchWin::TSketchWin(PTWindowsObject AParent, LPSTR ATitle)
  : TWindow(AParent, ATitle)
{
  AssignMenu(IDM_MENU);
  dragging = FALSE;
}

// Erase window
void TSketchWin::IDMErase(RTMessage)
{
  InvalidateRect(HWindow, NULL, TRUE);
}

// Exit program
void TSketchWin::IDMExit(RTMessage)
{
  CloseWindow();
}

// Respond to left-mouse-button click
void TSketchWin::WMLButtonDown(RTMessage Msg)
{
  if (!dragging) {
    dragging = TRUE;
    SetCapture(HWindow);
    dc = GetDC(HWindow);
    MoveTo(dc, Msg.LP.Lo, Msg.LP.Hi);
  }
}

// Respond to mouse movement
void TSketchWin::WMMouseMove(RTMessage Msg)
{
  if (dragging)
    LineTo(dc, Msg.LP.Lo, Msg.LP.Hi);
}

// Respond to release of left mouse button
void TSketchWin::WMLButtonUp(RTMessage)
{
  if (dragging) {
    ReleaseCapture();
    ReleaseDC(HWindow, dc);
    dragging = FALSE;
  }
}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
  LPSTR lpCmd, int nCmdShow)
{
  TSketchApp SketchApp("osketch", hInstance, hPrevInstance,
    lpCmd, nCmdShow);
  SketchApp.Run();
  return SketchApp.Status;
}
