; BENCHMKS.SC
; PC Tech Journal Data Manager Template Benchmarks -- Main Program
; Will Fastie -- 12/16/85
; Edit:  12/20/85 1020

clear
clearall
title = format("w80,ac", "PC Tech Journal Data Manager Benchmarks")
@2,0
style reverse
?? title
style
@4,0
text

     This program automatically runs the five benchmarks specified
in the Software Review Specification for Data Management Products.

     Start, stop, and elapsed times are given.  Elapsed times can
be up to 24 hours long and are correct across midnight.


endtext
mar = 5                     ; establish report margin


showmenu
  "All":           "Run all 5 benchmark programs",
  "NoLoad":        "Do not run import tests; run all others",
  "Special":       "Run a special sequence of the tests",
  "Exit":          "Return to main program"
default "All"
to choice


; Invoke benchmarks
@row(),0
  style reverse
  ?? format("w80,ac", "Benchmark Timings for PARADOX on " +
                       strval(today()) +" at " + strval(time()) )
  style
@row()+1, mar
  ?? "Benchmark Name            Start              "
  ?? "Stop               Nr Secs"
@row()+1, mar
  ?? "------------------------  -----------------  "
  ?? "-----------------  -------"

switch

  case choice = "All":
    play "bench1"
    play "bench2"
    play "bench3"
    play "bench4"
    play "bench5"

  case choice = "NoLoad":
    play "bench2"
    play "bench3"
    play "bench4"
    play "bench5"

  case choice = "Special":
    r = row()  c = col()
    @0,0 ?? "Enter the sequence (e.g., 455):  "
    accept "a10" to sequence
    @r,c
    while len(sequence) > 0
      seq = substr(sequence, 1, 1)
      if len(sequence) = 1
        then sequence = ""
        else sequence = substr(sequence,2,len(sequence)-1)
      endif
      if seq <> " " and search(seq, "12345") <> 0
        then EXECUTE "play \"bench" + seq + "\""
      endif
    endwhile

  case choice = "Exit":        return
  otherwise:                   return
endswitch


; Wait for results to be recorded on paper
@24,0
style reverse
?? format("w77,ar","Press Shift-PrtSc to print, other to exit")
style reverse, blink
?? "..."
style
x = getchar()   ;wait for a keypress
clearall
return


; end BENCHMKS.SC
