 /* vbigfile.c -  400 line sample program */
#include "stdio.h"

#include "bigfile1.h"
#include "bigfile2.h"
#include "bigfile3.h"

 long top_of_page ;
 FILE *diskfile ;                   /* file pointer for text file */
 char filename[81] ;
 long filesize ;                  /* size of the file in bytes */

 main()
 {
    int cmd ;                     /* holds current cmd     */
    long new_pos  ;               /* holds input file position */
                                  /* from move to cmd */

    get_filename() ;              /* get file name and open file */
    set_filesize() ;              /* set up file size variable */
    cmd = FIRSTPAGE ;             /* force display of 1st page */

    do {                          /* repeat until told to exit */
         exec_cmd(cmd,new_pos);   /* execute the current command */
         cmd = get_cmd(&new_pos); /* get the next command */
       } while( cmd != EXITPGM );

    close_data_file() ;
 }


 /* viewget.c - get_cmd function - get an input command  */


/* definitions of key values returned by getkey */

 int get_cmd(new_pos)      /* get next input command from keyboard */
                           /* returns the command type entered */
 long int *new_pos ;       /* store the new file position here */
 {
    int key ;              /* holds the keyboard input value */
			   /* ( see keyio.h ) for values */
    int cmd ;              /* holds the command type value */
    long get_new_pos();    /* declare it so type is known  */

                           /* display prompts */
    printf(  "\n         Type one of these Input Commands");
    printf(  "\n HOME  = First Page      ");
    printf(    "  %c   = Previous Line   ",24);
    printf(     "PG UP = Previous Page ");
    printf(  "\n END   = Last  Page      ");
    printf(    "  %c   = Next Line       ",25);
    printf(     "PG DN = Next Page \n");
    printf(  "\n ESC   = Exit Pgm        ");
    printf(     "SPACE = Move to position ");

    do
      { key = getkey() ;   /* get next keyboard input */
        switch( key )      /* classify it */
          {
          case PGDNKEY : cmd = NEXTPAGE       ;break;
          case PGUPKEY : cmd = PREVPAGE       ;break;
          case ASCESC  : cmd = EXITPGM        ;break;
          case ' '     : cmd = MOVETOPOS      ;break;
          case HOMEKEY : cmd = FIRSTPAGE      ;break;
          case ENDKEY  : cmd = LASTPAGE       ;break;
          case UPARROW : cmd = PREVLINE       ;break;
          case DOWNARROW : cmd = NEXTLINE     ;break;
          default      : cmd = INVALIDCMD     ;
          }  /* end of switch stmt */
      } while( cmd == INVALIDCMD ) ;

    /* the move to position command requires a position as input */
    if (cmd== MOVETOPOS)
       *new_pos = get_new_pos() ;

    return(cmd) ;
 }



 long int get_new_pos()  
 {
    char scratch[81] ;     /* use to flush invalid input */
    long new_pos ;
    int  valid_input ;     /* flag for loop to test */
 
    /* get a new position from the keyboard and validate it */
    /* if it is not valid, repeat the process */
    valid_input = 0 ;
    do
      { printf("\n new file position: ");
        if( scanf("%ld",&new_pos) == 0 )
           {                         /* non-numeric input  */
             scanf("%s",scratch) ;   /* flush rest of line */
             printf("\n the file position must be numeric") ;
           }
        /* we've got a number - check its range */
        else if( new_pos < 0L )  /* is it > 0 ? */
           printf("\n the file position must be greater than zero");
        else if( new_pos > filesize ) /* is it within the file */
           { printf("\n the file position must be less than or equal to");
             printf(" %ld",filesize) ;
           }
        else valid_input = 1 ;   /* we can exit the loop now */
      } while( valid_input == 0  ) ;

    return(new_pos) ;
 }


            
 /* viewexec.c file - exec_cmd function - executes one input command  */

 int exec_cmd(cmd,new_pos)               /* execute input command */
 int cmd ;                               /* value of command to execute */
 long int new_pos ;                      /* where to position file next */
			                 /* ( only used with MOVETO cmd ) */
 {
       switch( cmd )  {
          case PREVPAGE  :               /* move backward to last page */
               move_backward(PAGE_SIZE - LINES_OVERLAP) ;
               display_page() ;
               break;
          case NEXTPAGE  :               /* move forward to next page */
               move_forward(PAGE_SIZE - LINES_OVERLAP);
               display_page() ;
               break;
          case EXITPGM :
               break;
          case MOVETOPOS :
               move_to(new_pos) ;        /* move to specified position */
	       set_top_page() ;          /* make it top_of_page for now */
               move_backward(0);         /* move to begin. of current line */
               display_page() ;
               break;
          case FIRSTPAGE  :
               move_to(0L);               /* move to beginning of file */
	       set_top_page() ;           /* make it the top of the page */
               display_page() ;
               break;
          case LASTPAGE  :
	       move_to(filesize) ;              /* move to end of file */
	       set_top_page() ;           /* make it the top of the page */
               move_backward(PAGE_SIZE); /* put the end of file at bottom */
               display_page() ;
               break;
	 case  PREVLINE :
	       move_backward(1) ;        /* move back one line */
	       display_page() ;
	       break;
         case  NEXTLINE :
	       move_forward(1);          /* move forward one line */
	       display_page() ;
               break;
          }
 }

 /* viewfind.c file - find module - moves to new positions in the file */


 int move_forward(nlines)
 int nlines ;               /* number of lines to move */
 {
    int c ;                 /* hold char here */

    move_to(top_of_page) ;       /* start at top of page */
    /* move forward until we find (nlines) end of lines or end of file */
    do {
         c = get_next_char() ;
         if( c  == END_LINE ) /* check for end of line */
             nlines = nlines - 1 ; 
       } while( (nlines  > 0) & (c != EOF_MARK) ) ;

    set_top_page() ;        /* make this the new top of the display page */
 }


 int move_backward(nlines)
 int nlines ;               /* number of lines to move */
 {                          /* zero lines means start of current line */
    int c ;                 /* hold char here */

    move_to(top_of_page) ;       /* start at top of page */
    nlines = nlines + 1 ;        /* add one for current line */
    /* move backward past (nlines) end of lines or to BOF */
    do {
         c = get_previous_char();
         if(  c  == END_LINE )
             nlines = nlines - 1 ;
       } while( (nlines > 0) & (c != BOF_MARK) ) ;

    /* we are now in front of a end of line char ( or at BOF ) */
    /* we must skip over the end of line char  unless we are at BOF */
    if( c != BOF_MARK )
        get_next_char() ;
    set_top_page() ;        /* make this position the new top of page */
 }


/* viewdisp.c file - display_page function - display current page of file */

#define TAB_WIDTH     8
#define PAGE_WIDTH   80
#define ASC_TAB       9
 int  row ;      /* current line of page */
 int  col ;      /* current column of page */

 display_page()
 {
    int c ;           /* hold the character here */
    int i ;           /* counter for writing string of dashes */

    row = 1 ;         /* set up starting row and column values */
    col = 1 ;

    move_to(top_of_page); /* start out at top of the page */
                     /* write a header line */
    printf("\n FILE - %s    POSITION - %ld    FILE SIZE - %ld \n",
    filename,top_of_page,filesize);

                      /* write a border line of dashes */
    for( i=1 ; i <= 80 ; i = i + 1 )
       { putchar('-'); }

    /* get chars from file until we've written (PAGE_SIZE) lines */
    /* or we've reached the end of the file */
    c = get_next_char() ;
    while( ( row <= PAGE_SIZE ) && ( c != EOF_MARK ) )
      {                             /* write til end of page or file */
       disp_char(c) ;               /* display current character */
       c = get_next_char() ;        /* and get another one */
      }

    while( row <= PAGE_SIZE )        /* pad out page if eof reached */
      { putchar('\n'); row = row + 1 ; }

				    /* write a border line of dashes */
    for( i=1 ; i <= 80 ; i = i + 1 )
       { putchar('-'); }

 }



 int disp_char(c)                   /* display one char */
				    /* and update row and column */
 int c ;                            /* value of char to write */
 {
    /* classify the character and handle accordingly */

    if( c >= 32 )                  
      { putchar(c);             /* ASCII graphic character - display it */
        col = col + 1 ;             /* advance column number */
        if( col > PAGE_WIDTH )      /* check for wrap-around */
          { row = row + 1 ;         /*   y - advance row no  */
            col = 1 ;               /*       and set column back to first col*/
          }
      }
    else if( c == END_LINE )
      { putchar('\n') ;             /* end of line char - force a new line */
        row = row + 1 ;             /* advance row no. */
        col = 1 ;                   /* set column back to first col */
      }
    else if( c == ASC_TAB )
      {
	do                          /* tab - expand it */
          { putchar(' ');           /* print spaces    */
	    col = col + 1 ;         /* and advance column no. */
            if( col > PAGE_WIDTH )  /* checking for wrap-around */
              { row = row + 1 ;
                col = 1 ;
	      } 
          } while( ( col % TAB_WIDTH ) != 1 ) ; /* until tab stop reached */
      } 
 }

 /* viewio.c file - I/O module for VIEW program */


 /* seek mode definitions */
#define  CURRENT_REL   1 
#define  EOF_REL       2 
#define  BOF_REL       0 

 /* control Z character - marks EOF in CP/M convention */
#define  CTL_Z        26

/* extern long int fseek() ;*/
 extern long int ftell() ;

 int get_filename()               /* get name of file and open it */
 {
    do
      { printf("file name:") ;
        scanf("%s",filename) ;
        diskfile = fopen(filename,"rb") ;
        if (diskfile == 0)
           printf("\n file - %s can not be opened\n",filename);
      } while( diskfile == 0 ) ;
 }

 
 int set_filesize()             /* set up file size */
 {
    long current_position ;
    int c ;
    
    filesize = fseek(diskfile,0L,EOF_REL) ;  /* get size of file */

    /* check last 128 byte block for a CTL-z */
    fseek(diskfile, (filesize-1) & ~ 0x7f ,BOF_REL);
    do {
         c = getc(diskfile); 
       } while( (c != CTL_Z) & (c != EOF) );

    /* set filesize to be in front of the control-Z (if it was found) */
    if( c == CTL_Z )
        filesize = ftell(diskfile) - 1 ;  
 }



 int move_to(new_pos)           /* move to specified position */
 long new_pos ;
 {
    fseek(diskfile,new_pos,BOF_REL);
 }


 int set_top_page()             /* make the current file position */
 {                              /* new top of page */
   top_of_page = ftell(diskfile) ;
 }




 int get_next_char()           /* get char at file position */
 {
    char c ;

    if( ftell(diskfile) == filesize )   /* are we at end of file ? */
        return( EOF_MARK ) ;            /*   y - return our end file mark */
    else
      { /* not at end - read the next byte from the file */
        c = getc(diskfile);             /* get a char */
        return( (c & 0x7f) ) ;     /* set parity bit to zero and return it */
      }
 }



 int get_previous_char()         /* read the char in front of */
 {                               /* current file position */
    char c ;

    if( ftell(diskfile) != 0L )            /* check for begin. file */
       { fseek(diskfile,-1L,CURRENT_REL);  /* back up one char */
         c = getc(diskfile);               /* read a char*/
	 fseek(diskfile,-1L,CURRENT_REL) ; /*  back up in front of char read*/
         return( (c & 0x7f) ) ;          /* set the parity bit to zero */
				         /* and return the char */
       }
    else return(BOF_MARK) ;
 }


 int close_data_file()
 {
    fclose(diskfile) ;
 }
  


 int keypress()
 {
   if ((bdos(0xb,0) & 0xff) == 0xff)
       return( 1) ;
      else return(0) ;
 }

 int getkey()
 {
    int c ;

    c = (bdos(0x8,0) & 0xff) ;
    if (c == 0) c = 0x100 + (bdos(0x8,0) & 0xff) ;
    return(c) ;
 }

                        
