/*+
	Name:	    HLANALYZ.C
	Author:     Kent J. Quirk
		    (c) Copyright 1988 Ziff Communications Co.
	Date:       April 1988
	Abstract:   The program to analyze & compare benchmark data.
	History:    09-Sep-88	kjq	Version 1.00
-*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <graph.h>
#include <dos.h>
#include <conio.h>
#include <time.h>

#include "hl.h"
#include "hltimes.h"
#include "winmenu.h"

char *menu[] = {
    "Select a different reference machine",
    "Display data for the reference machine",
    "Select a machine to compare to the reference           ",
    "Display data for comparison machine",
    "Text comparison of both machines",
    "Graphical comparison of major features",
    "Printed comparison in detail", 
    "Return to main menu",
    NULL
};

char *horizline = "";
WINDOW *w;

#define MAXLINES 10
char text[MAXLINES][80];
char *tmenu[MAXLINES];

/**** c e n t e r ****
    Abstract:	Given a buffer and its width, this centers a string 
		in the buffer.
    Parameters: char *dest - a buffer pointer
		int width - the desired width of the buffer
		char *str - a string shorter than dest
    Returns:	nothing
****************************/
void center(char *dest, int width, char *str)
{
    memset(dest, ' ', width);		/* pad with spaces */
    dest[width] = 0;			/* trailing trim */
    memcpy(dest+((width-strlen(str))/2), str, strlen(str));
}

/**** p r i n t _ c o m p a r e ****
    Abstract:	Prints a comparison of the data to a file or device, as set by 
		SET PRINTER=filename from DOS.
    Parameters: The names of the two .TIM files to compare.
    Returns:	Nothing
****************************/
void print_compare(char *f1, char *f2)
{
    int i, j;
    TIME_REC tr, *trp;
    char *fname, *fmt;
    FILE *pf;
    int done = 0;
    time_t ltime;
    
    
    
    if ((fname = getenv("PRINTER")) == NULL)
	fname = "LPT1";
    if ((pf = fopen(fname, "a")) == NULL)
    {
	char buf[80];
	sprintf(buf, "Printer/file %s not accessible!\a", fname);
	pop_error(buf);
	return;
    }
    
    /*
    printf("Printing on %s...", fname);
    */
    
    time(&ltime);
    fmt = ctime(&ltime);
    fmt[11] = 0;
    
    fprintf(pf, "PC Tech Journal System Benchmarks, version 1.00         ");
    fprintf(pf, "Printed %s%s", fmt, fmt+20);
    fprintf(pf, "\nReference Machine\n");
    opentime(f1);				/* print F1 header */
    for (j=0; ;j++)
    {
	trp = readtime(0, j);
	if (trp == NULL)
	    break;
	fprintf(pf, "    %-64.64s\n", trp->desc);
    }
    closetime();

    fprintf(pf, "Tested Machine\n");
    opentime(f2);				/* print F2 header */
    for (j=0; ;j++)
    {
	trp = readtime(0, j);
	if (trp == NULL)
	    break;
	fprintf(pf, "    %-64.64s\n", trp->desc);
    }
    closetime();

    fprintf(pf, "%-40.40s  %8.8s  %8.8s  %8s\n", 
		"\nDescription", f1, f2, "% of Ref.");
    for (i=1; !done ;i++)
    {
	for (j=1; ;)
	{
	    opentime(f1);
	    trp = readtime(i, j);
	    closetime();
	    if (trp == NULL)
		if (j == 0)
		{
		    done = 1;	    /* we tried to read i, 0 and it failed */
		    break;	    /* so we're done with everything */
		}
		else
		{
		    j = 0;	    /* we must be done with this i */
		    continue;	    /* read title line and finish */
		}
	    tr = *trp;
	    opentime(f2);
	    trp = readtime(i, j);
	    closetime();
	    
	    if (tr.ticks == -1)
		if (trp->ticks == -1)
		{
		    if (j == 0) 	/* another place to be done */
			break;
		    j++;
		    continue;
		}
	    else
		strcpy(tr.desc, trp->desc);   /* use second desc */
	    
	    if (j == 0)
		fmt = "%40.40s  %8.8s  %8.8s  %8s\n\n";
	    else
		fmt = "%40.40s  %8.8s  %8.8s  %8s\n";
	    
	    fprintf(pf, fmt, tr.desc, time_secs(tr.ticks),
		time_secs(trp->ticks), time_pct(trp->ticks, tr.ticks));
	    
	    if (j == 0)     /* are we done with this i? */
		break;	    /* yes, quit */
	    else
		j++;	    /* no, increment j and do it again */
	}
    }
    fprintf(pf, "\x0C");	/* print form feed */
    fclose(pf);
    /*
    printf("Done.\n");
    */
}

/**** c o m p a r e _ t i m e s ****
    Abstract:	Compares times for two files, either on a summary or
		detail level. If prog==-1, does a summary.  If prog is a
		number, does details for that number.
    Parameters: char *f1, *f2 -- the names of the two files
		int prog - the "program" number to compare in detail, or -1
			    to compare summary numbers
		int offset - the offset within a given program to compare
		char *title - the title of the comparison menu
    Returns:	The number selected, if prog was -1, else -1.
    Comments:	This is pretty ugly.
****************************/
int compare_times(f1, f2, prog, offset, title)
char *f1, *f2;
int prog, offset;
char *title;
{
    int i, j;
    TIME_REC tr, *trp;
    long rel;
    char buf[65];
    int original[MAXLINES];
    int done = 0;

    j = 0;
    for (i=1; !done; i++)
    {
	opentime(f1);
	if (prog == -1)
	    trp = readtime(i, offset);		/* summary level */
	else
	{
	    if (i==0)
		++i;
	    trp = readtime(prog, i);
	    if (trp == NULL)
	    {
		trp = readtime(prog, 0);
		done = 1;
		i = 0;
	    }
	}
	closetime();
	if (trp == NULL)
	    break;
	tr = *trp;

	if (f2 != NULL)
	{
	    opentime(f2);
	    if (prog == -1)
		trp = readtime(i, offset);
	    else
		trp = readtime(prog, i);
	    closetime();
	}
	else
	    trp->ticks = -1;

	if (tr.ticks == -1)
	    if (trp->ticks == -1)
		continue;
	else
	    strcpy(tr.desc, trp->desc);   /* use second desc */

	if (prog == 0)
	    sprintf(text[j], "%-63.63s", tr.desc);
	else
	    sprintf(text[j], "%32.32s:  %8.8s  %8.8s  %8s", tr.desc,
		time_secs(tr.ticks), time_secs(trp->ticks),
		time_pct(trp->ticks, tr.ticks));
	tmenu[j] = text[j];
	original[j] = i;
	j++;
    }

    if (j == 0)
    {
	pop_error("There is no data in the file yet.  Run some tests first.");
	return(-1);
    }
	
    tmenu[j] = NULL;
    if (f2 == NULL)
	f2 = " N/A  ";

    if (prog == 0)
	sprintf(buf, "%-32.32s%23.23s%8s", horizline, " ", f1);
    else
	sprintf(buf, "%-32.32s   %8.8s  %8.8s  %8s", horizline,
		f1, f2, "% of Ref");

    if ((i = do_menu(tmenu, buf, title, (prog == -1) ? 0 : -1)) < 0)
	return(i);
    else
	return(original[i]);
}

/**** t e x t _ c o m p a r e ****
    Abstract:	Performs a text-based file comparison; calls 
		compare_times appropriately.
    Parameters: The two filenames to compare
    Returns:	Nothing.
****************************/
void text_compare(f1, f2)
char *f1, *f2;
{
    int select;

    while ((select = compare_times(f1, f2, -1, 0,
	    "Press Enter for detail, ESC to return.")) >= 0)
    {
	compare_times(f1, f2, select, -1, "Press ESC to exit");
    }
}

/**** o n e _ t e s t _ d e t a i l ****
    Abstract:	Compares details for a specific test; used by 
		HLBENCH after running a specific test; lets the 
		user see the results immediately.
    Parameters: The test number to compare
    Returns:	Nothing
****************************/
void one_test_detail(f1, f2, test)
char *f1, *f2;
int test;
{
    compare_times(f1, f2, test, -1, "Press ESC to exit");
}

/**** g r a p h _ c o m p a r e ****
    Abstract:	Compares two summary files graphically.
    Parameters: The two files to compare
    Returns:	Nothing
****************************/
void graph_compare(f1, f2)
char *f1, *f2;
{
    int i, j;
    TIME_REC tr, *trp;
    char buf[80];
    long times1[MAXLINES];
    long times2[MAXLINES];
    long tmin = 9999L, tmax = -1;
    int nitems = 0;
    WINDOW *w;

    j=0;
    for (i=0; ; i++)
    {
	opentime(f1);
	trp = readtime(i, 0);
	closetime();
	if (trp == NULL)
	    break;
	tr = *trp;

	opentime(f2);
	trp = readtime(i, 0);
	closetime();

	times1[j] = tr.ticks;
	times2[j] = trp->ticks;
	if (tr.ticks <= 0)
	    if (trp->ticks <= 0)
		continue;
	    else	    
		strcpy(tr.desc, trp->desc);   /* use second desc */

	sprintf(text[j], "%d) %-32.32s   ~%8.8s  ~%8.8s  ~%8s", j+1, tr.desc+7,
	    time_secs(tr.ticks), time_secs(trp->ticks),
	    time_pct(trp->ticks, tr.ticks));
	++j;
    }

    w = open_window(1, 1, 25, 80, 7);
    draw_times(times1, times2, text, j, f1, f2);
    close_window(w);
}

/**** a n a l y z _ m e n u _ i n i t ****
 **** a n a l y z _ m e n u _ l i n e ****
 **** a n a l y z _ m e n u _ e x i t ****
    Abstract:	These functions are called by scroll_menu during the
		file select function; they display the data corresponding
		to a selected file in a separate window.
    Parameters: As defined in scroll_menu.
    Returns:	Nothing
    Comments:	The menu size and position are hard coded (ugly).
****************************/
void analyz_menu_init()
{
    w = open_window(5, 18, 12, 77, 0);
}

void analyz_menu_line(char *text, int item)
{
    char buf[80];
    TIME_REC *trp;
    int i;
    
    strcpy(buf, text);
    *strchr(buf, '.') = 0;
    if (kbhit())
	return;
    opentime(buf);
    for (i=0; i<8; i++)
    {
	if (kbhit())
	{
	    closetime();
	    return;
	}
	trp = readtime(0,i);
	_settextposition(i+5,18);
	sprintf(buf, "%-60.60s", trp->desc);
	_outtext(buf);
    }
    closetime();
}
void analyz_menu_exit()
{
    close_window(w);
}

/**** u s a g e ****
    Abstract:	Prints user instructions and exits.
    Parameters: None
    Returns:	Never returns.
****************************/
void usage()
{
    printf("Usage:  HLANALYZ [-pprog -ffile] [-sstandard]\n");
    printf("   Without prog specified, allows comparison of benchmark\n");
    printf("   results.  With it, prog is the program number assigned by\n");
    printf("   HLBENCH, and file and standard are the filenames for the\n");
    printf("   files.  With prog specified, file must be included.\n");
    exit(1);
}

/**** m a i n ****
****************************/
int main(argc, argv)
int argc;
char *argv[];
{
    char *ff = NULL, *fs = NULL, *t;
    int ch = 5;
    char *buf[200];
    char title[50];
    int i;
    int prog = -1;

    for (i=1; i<argc; i++)
    {
	if (argv[i][0] != '-')
	    usage();

	switch(tolower(argv[i][1])) {
	case 'p':
	    prog = atoi(argv[i]+2);
	    break;
	case 'f':
	    if (argv[i][2] != 0)
		ff = strdup(argv[i]+2);
	    else
		ff = NULL;
	    break;
	case 's':
	    if (argv[i][2] != 0)
		fs = strdup(argv[i]+2);
	    else
		fs = NULL;
	    break;
	case 'a':		    /* ignore "batch" & "bench" modes */
	case 'b':
	    break;
	default:
	    printf("Invalid argument '%s'\n", argv[i]);
	case '?':
	    usage();
	}
    }

    if (prog >= 0)			    /* program number specified */
    {
	if (ff == NULL)
	    usage();			    /* being used wrong */
	one_test_detail(fs, ff, prog);	    /* show results of one test */
	exit(0);
    }

    menu_init = analyz_menu_init;	    /* set up menu user exits */
    menu_line = analyz_menu_line;
    menu_exit = analyz_menu_exit;
    
    for(;;)
    {
	sprintf(title, " Display and compare %s and %s ",
	    (fs == NULL ? "(none)" : fs), (ff == NULL ? "(none)" : ff));
	if ((ch = do_menu(menu, title, 
			"Press Enter to select, ESC to return", ch)) == -1)
	    return(0);
	else
	{
	    switch (ch) {
	    case 0:
		if ((t = select_1_file("*.tim")) != NULL)
		{
		    if (fs != NULL)
			free(fs);
		    fs = t;
		}
		break;
	    case 1:
		if (fs != NULL)
		    text_compare(fs, NULL);
		else
		{
		    pop_error("You must select a machine first!");
		    ch = 0;
		}
		break;
	    case 2:
		if ((t = select_1_file("*.tim")) != NULL)
		{    
		    if (ff != NULL)
			free(ff);
		    ff = t;
		}
		break;
	    case 3:
		if (ff != NULL)
		    text_compare(ff, NULL);
		else
		{
		    pop_error("You must select a machine first!");
		    ch = 0;
		}
		break;
	    case 4:
	    case 5:
	    case 6:
		if ((fs == NULL) || (ff == NULL))
		{
		    pop_error("You must specify both machines first!");
		    if (fs == NULL)
			ch = 0;
		    else
			ch = 2;
		}
		else if (ch == 4)
		    text_compare(fs, ff);
		else if (ch == 5)
		    graph_compare(fs, ff);
		else if (ch == 6)
		    print_compare(fs, ff);
		break;
	    case 7:
		return(0);
	    }
	}
    }
}

