/*+
    Name:	hlwindow.c
    Date:	07-Sep-1988
    Author:	Kent J. Quirk
		(c) Copyright 1988 Ziff Communications Co.
    Abstract:	This tests speed of direct video access.
    History:	09-Sep-88   kjq     Version 1.00
-*/    

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <graph.h>
#include "hl.h"
#include "hltimes.h"
#include "winmenu.h"

void usage()
{
    printf("Usage:  HLWINDOW [-?] [-nNLINES]\n");
    printf("This program opens seven windows in succession using\n");
    printf("direct video writes to do its work.  In each window, it\n");
    printf("uses the MSC _outtext() function to write NLINES lines\n");
    printf("text to the screen.  It then closes all the windows one\n");
    printf("by one, writing NLINES of text again before closing.\n");
    printf("NLINES defaults to 50.\n");
    exit(1);
}

char *sayings[] = {
    "To be, or not to be, that is the question.\n",
    "To err is human; to really foul things up requires a computer.\n",
    "Consistency is the hobgoblin of small minds.\n",
    "Friends, Romans, and countrymen, lend me your ears.\n",
    "Quoth the Raven, 'Nevermore.'\n",
    "I think that I shall never see a billboard lovely as a tree.\n",
    "For the snark was a boojum, you see.\n",
    "A rolling stone gathers no moss.\n",
    "Brevity is the soul of wit.\n",
    "Call me Ishmael.\n",
    "'Curiouser and curiouser,' said Alice.\n",
    "A stitch in time saves nine.\n",
    "It was the best of times, it was the worst of times.\n",
};

TIME_REC timerec[] = {
    {  0L, "Total: Window/Scrolling"	 } ,
    {  -1L, "HLWINDOW"	   } ,
};

#define hbound(a) (sizeof(a)/sizeof(a[0]))
main(argc, argv)
int argc;
char *argv[];
{
    WINDOW *w[100];
    WINDOW *base;
    int i,j;
    int nlines = 50;
    struct rccoord cpos;
    int program = -1;
    char *filename = NULL;

    for (i=1; i<argc; i++)
    {
	if (argv[i][0] != '-')
	    usage();

	switch(tolower(argv[i][1])) {
	case 'n':
	    nlines = atoi(argv[i]+2);
	    break;
	case 'a':
	case 'b':
	    break;          /* ignore batch switch */
	case 'p':
	    program = atoi(argv[i]+2);
	    break;
	case 'f':
	    filename = argv[i]+2;
	    break;
	default:
	case '?':
	    usage();
	    break;
	}
    }

    cpos = bios_getcur();
    start_timer(0);
    base = open_window(1, 1, 25, 80, 0xF);

    for (i=1; i<8; i++)
    {
	w[i] = open_window(2+i, 30-4*i, 24-i, 50+4*i,
	(char)(((i) << 4) & 0x70) + (((3+i) & 0x0F) | 0x80));
	activate_window(w[i]);
	_settextposition(25,1);
	for (j=0; j<nlines; j++)
	    _outtext(sayings[j % hbound(sayings)]);
	deactivate_window(w[i]);
    }

    for (i=7; i>0; i--)
    {
	activate_window(w[i]);
	for (j=0; j<nlines; j++)
	    _outtext(sayings[j % hbound(sayings)]);
	deactivate_window(w[i]);
	close_window(w[i]);
    }

    close_window(base);
    stop_timer(0);
    bios_setcur(cpos.row, cpos.col);
    printf("Window/scrolling test took %s seconds.\n",
    time_secs(timerec[0].ticks = get_timer(0)));

    if ((program != -1) && (filename != NULL))
    {
	opentime(filename);
	savetime(program, 0, &timerec[0]);
	savetime(program, 1, &timerec[1]);
	closetime();
    }
    return(0);
}
