let trace_chan = ref std_out;;

let start output_name =
  trace_chan := open_out_bin output_name
;;

let prefix <. v1 v2 =
  output_char !trace_chan `c`; v1 < v2
;;

let prefix <=. v1 v2 =
  output_char !trace_chan `c`; v1 <= v2
;;

let vect_assign t i v =
  output_char !trace_chan `a`;
  output_binary_int !trace_chan i;
  output_binary_int !trace_chan v;
  t.(i) <- v
;;

let exchange t i j =
  let v = t.(i) in vect_assign t i t.(j); vect_assign t j v
;;

let stop () =
  close_out !trace_chan
;;
