/* The "get_next_char" routine for lexers generated by camllex. */

#include "mlvalues.h"
#include "instruct.h"
#include "stacks.h"
#include "str.h"

struct lexer_buffer {
  value refill_buff;
  value lex_buffer;
  value lex_abs_pos;
  value lex_start_pos;
  value lex_curr_pos;
  value lex_last_pos;
  value lex_last_action;
};

static unsigned char callback[] = {
  POP, APPLY, STOP
};

value get_next_char(lexbuf)     /* ML */
     struct lexer_buffer * lexbuf;
{
  mlsize_t buffer_len, curr_pos;
  
  buffer_len = string_length(lexbuf->lex_buffer);
  curr_pos = Long_val(lexbuf->lex_curr_pos);
  if (curr_pos >= buffer_len) {
    *--extern_asp = MARK;
    *--extern_asp = (value) lexbuf;
    *--extern_asp = lexbuf->refill_buff;
    interprete(callback);
    curr_pos = Long_val(lexbuf->lex_curr_pos);
  }
  lexbuf->lex_curr_pos += 2;
  return Val_int(Byte_u(lexbuf->lex_buffer, curr_pos));
}

