/*
 EPSHeader

   File: sort.h
   Author: J. Kercheval
   Created: Wed, 05/15/1991  21:57:06
*/

/*---------------------------------------------------------------------------
*
*  09-10-91
*
*    Add support for external cleanup routine on signal exit when used
*    as a separate module
*
*                                jbk
*  09-05-91
*
*    Fixed a bug when using sort as a module.  Output file was not being
*    closed.  Sort.exe relied on the exit code to close the output file.
*
*                                jbk
*  07-19-91
*
*    Fixed an insidious little bug which prevented duplicate symbol delete
*    when key fields or parameters were in use (ie sort -u -f ).
*
*                                jbk
*  05-15-91
*
*    Calling this routine with all the requested filename in argv and the
*    number of parameters in argc will yeild a sorted set of files in one
*    output block.  Normal command line parameters may be passed as noted
*    below.
*
*                                jbk
*
*
*    General introduction to GNU `sort'.
*    ***********************************
*
*    This is an MS-DOS port of the (unreleased) external sort program for
*    the GNU project, written by Mike Haertel.
*
*       * *PLEASE NOTE*:  Mike Haertel (the original author) allowed me to
*         distribute this program under the condition that I make clear
*         that this program has not been tested extensively and is to be
*         considered as in a pre-alpha test state.
*
*    I have decided to distribute this program anyway, because it
*    outclasses *any* external sort program I have seen for MS-DOS: both
*    in performance and functionality.
*
*       * Performance:
*
*           1. When used with a fast (preferably cached) disk, this
*              program is as fast as V. Buerg's `sortf' (if the latter is
*              used with large, non default keys, GNU `sort' is
*              *considerably* faster).
*
*           2. There are (almost) no build-in hard limits!  (I have put
*              one hard and one soft limit in the MS-DOS version, *note
*              MS-DOS::.).
*
*       * Functionality:
*
*           1. GNU `sort' works as a filter.
*
*           2. GNU `sort' has lots of *useful* options (*note Options::.).
*
*    This distribution is different from the other ports of GNU software
*    for MS-DOS: it contains the full, unabridged source code and no
*    context diffs.  This is because GNU `sort' has not yet been released
*    by the Free Software Foundation, and therefore you can't pick up the
*    official source from prep.  But: *all* changes (which are very few)
*    are conditionalized with `MSDOS'.
*
*    Please send bug reports (preferably with fixes (*context* `diff''s!) to
*
*               Thorsten Ohl
*               <td12@ddagsi3.bitnet>
*
*    I can make no promises to fix it immediately, but I might want to!
*
*
*    How to install the MS-DOS version of GNU `sort'.
*    ************************************************
*
*      1. Edit the following variables in the makefile
*
*        `LIBS'
*              Remove `glob.obj', `msd_dir.obj', and `_cwild.obj' if you
*              don't have `glob.c', `msd_dir.c', `msd_dir.h', and
*              `_cwild.c' from the other MS-DOS ports (e.g. fileutils), or
*              if you do not want a reasonable filename globbing.
*
*        `VPATH'
*              Include path for `glob.c', `msd_dir.c', `msd_dir.h', and
*              `_cwild.c' on *your* system.  If you have a loosing (non
*              GNU) `make' that doesn't understand `VPATH', copy the
*              sources in your current directory.
*
*        `CFLAGS, LDFLAGS'
*              These are for the Microsoft C compiler Version 6.0, edit
*              them for your system:
*
*             `-AC'
*                   Compact memory model
*
*             `-W4'
*                   Full warnings!
*
*             `-Ocgilt'
*                   (Almost) maximal optimization.
*
*             `-Za'
*             `-DSTDC_HEADERS'
*                   ANSI C.
*
*             `-DUSG'
*                   Microsoft's C looks more like System V than BSD.
*
*             `/e'
*                   Pack the executable.
*
*             `/st:0x8000'
*                   Large stack.
*
*             `/noe'
*                   If duplicate symbols in object files and libraries,
*                   use the one from the object file.
*
*      2. Say `make'.
*
*    That's all.
*
*
*    Options for GNU `sort'
*    **********************
*
*         `sort' [-cmuV] [-t c] [-o `file'] [-T `dir']
*                [-bdfiMnr] [+n [-m] ...] [`file' ...]
*
*    The following is a guide to GNU `sort', *not* a collection of
*    *documented options* that can be relied on.
*
*    * Menu:
*
*    * Global::         Options affecting all sort keys together.
*    * Keys::           Specification of the sort keys.
*    * Local::          Options for one or all sort keys.
*
*
*    Options affecting all sort keys
*    ===============================
*
*    `-c'
*         Check sort order  only.
*
*    `-m'
*         Merge presorted files (avoids resorting of already sorted files,
*         which is generally a slow operation).
*
*    `-o`file''
*         Send output to `file' (overwriting).
*
*    `-tc'
*         Use c as field separator.
*
*    `-T`prefix''
*         Use `prefix' as prefix for temporary files (e.g.
*         `prefix/sort3141.137'), default is `$TMP'.
*
*    `-u'
*         Delete duplicate lines from the output.
*
*    `-V'
*         Print the version string
*
*    *Note Local:: for more options that can affect all keys.
*
*
*    How to specify the sort keys
*    ============================
*
*    Keys are zero based, thus the first field has number 0, and so on.
*
*    `+num1.num2'
*         Start a new key at character num2 of field num1.
*
*    `-num1.num2'
*         Extend the key upto (not including) character num2 of field num1.
*
*
*    Options affecting one or all sort keys
*    ======================================
*
*    These option apply either globally to all sort keys (if they are
*    specified before the keys on the command line), or to a single key
*    (if they are appended to the key specification).
*
*    `-b'
*         Skip white space.
*
*    `-d'
*         Dictionary mode: ignore punctuation.
*
*    `-f'
*         Fold to lowercase.
*
*    `-i'
*         Ignore nonprinting characters.
*
*    `-M'
*         Sort as english (three character) month names.
*
*    `-n'
*         Sort numrically.
*
*    `-r'
*         Sort in reverse.
*
*
*    How the MS-DOS version differs
*    ******************************
*
*       * The maximum line length has been reduced to 32k.  While the
*         introduction of arbitrary upper limits is alien to the GNU
*         project, this particular limit seems to be o.k. for MS-DOS
*         applications and tremendously decreases the number of required
*         changes in the original source.
*
*       * The maximum number of lines per input buffer is restricted to
*         about 4000.  This limit can only be reached by files with an
*         average linelength smaller that 8 characters.  To allow the
*         sorting of such files, the following option has been included to
*         reduce the input buffer size:
*
*        `-S num'
*              Set the input buffer size (default 32k) to num.
*
---------------------------------------------------------------------------*/

int sort_main(int argc, char *argv[]);

/*---------------------------------------------------------------------------
 *
 * external_cleanup() is called in the sort module but is not defined there.
 * The caller of the sort module should define this routine which is called
 * should there be an abnormal program termination handled by a signal.
 *
 *-------------------------------------------------------------------------*/

void external_cleanup(void);
