// task.hxx
//
// implements the Task class.  this manages the spawning of an OS/2 thread.
//
// author: vaughn vernon
// (c) Copyright 1988 Aspen Scientific
// All Rights Reserved.

#ifndef __TASKCLASS__
# define __TASKCLASS__
# ifndef APIENTRY
#	include <os2def.h>
# endif
# ifndef INCL_DOS
#	define INCL_DOS
#	include <bsedos.h>
# endif

// the Task class

class Task {

	USHORT	returnCode;

public:

	// constructor, it spawns the thread
	Task( VOID auto (FAR * routine)(), USHORT stackSize ) {

		PBYTE stack;	// the stack pointer
		TID taskID;	// the thread/task ID

		stack = (PBYTE) new BYTE[ stackSize ];

		if ( stack != PBYTE(0) ) {

			// the stack grows down
			stack += stackSize;

			// spawn thread
			returnCode = DosCreateThread( routine,
					(PTID) &taskID, (PBYTE) stack );
		}
		else
			returnCode = TRUE;	// in this case bad
	}

	// the destructor does nothing
	// the stack is freed by OS/2 when the Task completes.
	~Task()		{ ; }

	// methods

	// was the thread executed?
	BOOL	GetStatus()	{
		return returnCode ? FALSE:TRUE;
	}
};
#endif
