/*
 * winstack.c	winPush(win) and winPop().
 *
 *		manage a stack of CURSES windows.
 *
 * (c) Copyright 1988 Aspen Scientific
 * All Rights Reserved.
 */

#include <curses.h>
#include "winstack.h"	/* some defines */

/* the stack
 */
static WINDOW *ws[ WIN_MAX ];

static int ws_idx = 0;

int
winPush( win )
WINDOW *win;
{
	/** stack overflow?
	 **/
	if (ws_idx == WIN_MAX)
		return (0);		/** error **/

	touchwin( win );
	wrefresh( win );

	ws[ ws_idx++ ] = win;

	return (1);			/** good **/
}

void
winPop()
{
	register int i;

	/** stack underflow?
	 **/
	if (ws_idx == 0)
		return;

	ws[ --ws_idx ] = (WINDOW *)0;

	i=0;
	while (i < ws_idx) {
		touchwin(ws[i]);
		wnoutrefresh(ws[i]);	/* to virtual screen */
		++i;
	}

	doupdate();	/* to physical screen */
}
