/*
 * Winaux main module
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 * See Winaux.doc for usage information
 *
 */

#define NOCOMM
#define NOKANJI
#define NOMINMAX
#include <io.h>
#include <windows.h>
#include <ttycls.h>

#define EXTERN
#include "winaux.h"

/* entry point for windows */
int FAR PASCAL WinMain(hInstance, hPrevInstance, lpszCmdLine, cmdShow)
HANDLE hInstance, hPrevInstance;
LPSTR lpszCmdLine;
int cmdShow;
{

    MSG msg;

    /* initialize program */
    if (!InitProgram(hInstance,hPrevInstance, lpszCmdLine, cmdShow))
      /* if we fail, then exit */
	return FALSE;

    /* otherwise read messages until program is terminated by user */
    while (GetMessage((LPMSG)&msg,NULL,0,0)) {
	TranslateMessage((LPMSG)&msg);
	DispatchMessage((LPMSG)&msg);
    }
    return msg.wParam;
}

/* main window procedure */
long FAR PASCAL MainWndProc(hWnd,message,wParam,lParam)
HWND hWnd;
unsigned message;
WORD wParam;
LONG lParam;
{

    PAINTSTRUCT ps;
    
    switch(message) {

      /* adjust position of text display if window is resized */
	case WM_SIZE:
	    AdjustHeight(LOWORD(lParam), HIWORD(lParam));
	    break;

      /* menu commands */
	case WM_COMMAND:
	    WndCommand(hWnd, wParam);
	    break;

      /* display string from remote program */
	case WM_USER:
	    if (!IsIconic(hWnd))
	        DispatchString(hWnd, wParam, lParam);
	    break;

      /* initialize some things when window is created */
	case WM_CREATE:
	    WndCreate(hWnd,lParam);
	    break;

      /* quit */
	case WM_DESTROY:
	    PostQuitMessage(0);
	    break;

      /* set window handle to null in win.ini when closing application */
	case WM_CLOSE:
	    SetWinIni(NULL);
	    if (hFile)
		close(hFile);
	    DestroyWindow(hWnd);
	    break;

      /* if closing Windows, set window handle to null in win.ini */
	case WM_ENDSESSION:
	    if (wParam) {
		if (hFile)
		    close(hFile);
		SetWinIni(NULL);
	    }
	    break;

      /* refresh the window */
	case WM_PAINT:
	    BeginPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    MainWndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    EndPaint(hWnd, (LPPAINTSTRUCT)&ps);
	    break;

      /* all other messages are handled by windows */
	default:
	    return ((long)DefWindowProc(hWnd,message,wParam,lParam));
	    break;
    }
    return(0L);
}
