        title   wtest - window test
        include window.inc
        include asm.inc

        .stack

        .data
quick_txt       db      'The quick brown fox jumps over the lazy dog.'
now_txt         db      'Now is the time for all good men ...'

one_txt         db      '1'
two_txt         db      '22'
three_txt       db      '333'
four_txt        db      '4444'
five_txt        db      '55555'
test2_txt       db      'Test 2'
hidden_txt      db      'HiddenText'
stars_txt       db      '******************************'

twenty_txt      db      'twenty*twenty*twenty'
thirty_txt      db      '*thirty*thirty*thirty*thirty**'
forty_txt       db      'forty#forty#forty#forty#forty#forty#fort'
ninety_txt      db      15 dup ('ninety')

test_str struc
  t_handle      dw      ?
  t_origin_x    db      ?
  t_origin_y    db      ?
  t_size_x      db      ?
  t_size_y      db      ?
  t_x           db      ?
  t_y           db      ?
  t_offset      dw      ?
  t_bc          dw      ?
test_str ends

        even
w0      test_str  <0, 0,0,    90,1,   0,0,  ninety_txt,  90> ;size ninety_txt>
w1      test_str  <0, 1,1,    1,1,    0,0,  one_txt,     1>  ;size one_txt>
w2      test_str  <0, 2,1,    2,1,    0,0,  two_txt,     2>  ;size two_txt>
w3      test_str  <0, 4,1,    3,1,    0,0,  three_txt,   3>  ;size three_txt>
w4      test_str  <0, 7,1,    4,1,    0,0,  four_txt,    4>  ;size four_txt>
w5      test_str  <0, 11,1,   5,1,    0,0,  five_txt,    5>  ;size five_txt>
w6      test_str  <0, 1,2,    60,5,   50,5, test2_txt,   6>  ;size test2_txt>
w_count0        equ     ($-w0)/size test_str

w10     test_str  <0, 0,0,    40,1,   0,0,  quick_txt,   44> ;size quick_txt>
w11     test_str  <0, 0,1,    90,1,   1,0,  ninety_txt,  90> ;size ninety_txt>
w12     test_str  <0, 0,2,    20,1,   0,0,  0,           0>
w13     test_str  <0, 20,2,   20,1,   0,0,  0,           0>
w14     test_str  <0, 0,3,    40,1,   0,0,  0,           0>
w15     test_str  <0, 20,4,   10,1,   0,0,  0,           0>
w16     test_str  <0, 10,2,   20,3,   0,0,  0,           0>
w_count10       equ     ($-w10)/size test_str


        .code
        extn    startup,WCreateWindow,WDrawText,WPreset

        extrn    row_count:byte, column_count:byte

;;      main
;
main    proc
        mov     ax,@data
        mov     ss,ax
        mov     sp,offset stack
        mov     sp,ax
        call    startup
        call    WPreset

        mov	ah,06h          ;Scroll row_count lines to clear screen
        mov	dh,row_count    ;  and column_count columns
        mov	dl,column_count
        mov	al,0            ; blank the screen
        mov	bh,7
        mov	cx,0
        int 10h              

        mov     ax,@data
        mov     ds,ax
        lea     si,w0
        mov     cx,w_count0
mai1:   pushm   cx,si,ds
        mov     bx,NULL_WINDOW
        mov     cl,t_origin_x[si]
        mov     ch,t_origin_y[si]
        mov     dl,t_size_x[si]
        mov     dh,t_size_y[si]
        call    WCreateWindow
        mov     t_handle[si],bx
        mov     cx,t_bc[si]
        mov     dl,t_x[si]
        mov     dh,t_y[si]
        mov     si,t_offset[si]
        call    WDrawText

        popm    ds,si,cx
        add     si,size test_str
        loop    mai1

        lea     si,w10
        mov     cx,w_count10
mai2:   pushm   cx,si,ds
        mov     bx,w6.t_handle
        mov     cl,t_origin_x[si]
        mov     ch,t_origin_y[si]
        mov     dl,t_size_x[si]
        mov     dh,t_size_y[si]
        call    WCreateWindow
        mov     t_handle[si],bx
        mov     cx,t_bc[si]
        mov     dl,t_x[si]
        mov     dh,t_y[si]
        mov     si,t_offset[si]
        call    WDrawText

mai3:   popm    ds,si,cx
        add     si,size test_str
        loop    mai2

        mov     bx,w16.t_handle
        mov     cx,30 ;size stars_txt
        mov     dx,0
        lea     si,stars_txt
        call    WDrawText

        mov     dh,1
        call    WDrawText

        mov     dh,2
        call    WDrawText


        mov     bx,w12.t_handle
        mov     cx,44 ;size quick_txt
        lea     si,quick_txt
        mov     dx,0
        call    WDrawText


        mov     bx,w13.t_handle
        mov     cx,36 ;size now_txt
        lea     si,now_txt
        call    WDrawText


        mov     bx,w14.t_handle
        mov     cx,44 ;size quick_txt
        lea     si,quick_txt
        call    WDrawText


        mov     bx,w15.t_handle
        mov     cx,10 ;size hidden_txt
        lea     si,hidden_txt
        call    WDrawText

        ;Wait for a keypress
	mov	ah,1		;wait for a key
	int	21h		;

        mov     ax,4C00h
        int     21h
main    endp

        end     main
