	title	simple file server
	include	asm.inc
	include	netbios.inc

	public	main

	.stack

	.const
ertx_add_name		db  'Add Name error',0
ertx_driver		db  'No NetBIOS driver',0
ertx_send		db  'SEND error',0
ertx_listen		db  'LISTEN error',0
ertx_receive		db  'RECEIVE error',0
ertx_read_only		db  'Server only supports read requests',0
ertx_file_not_found	db  'File not found',0
ertx_read		db  'File read error',0

exiting_text		db  'Exiting',0
low_iq_server_text	db  'Low IQ Server',0
logo_text		db  'Simple NetBIOS File Server',13,10
			db  'Press ESC to exit',0

	.data?

listen_ncb	ncb <>

;
; the order of these four objects is important
;
position_req	dd  ?			; file position requested for transfer
length_req	dd  ?			; length of transfer request
direction_flag	db  ?			; 'r' for receive, 's' for send
filename_req	db FILENAME_MAX dup(?)	; requested file and path
		db  ?			; (ensure path is asciiz)

add_name	db  ?
session_number	db  ?

file_buffer	db  512 dup(?)


	.code
	extn  startup,netbios_check,netbios_add_name,clear_ncb,strcpy
	extn  netbios_receive_wait,get_input_state,puts,netbios_hang_up
	extn  exit_program,netbios_delete_name,netbios_cancel,close_file
	extn  netbios_send_wait,read_from_file,select_min_count,netbios_call
	extn  move_file_pointer,open_input_file

;;	main
;
main	proc
	assume	ds:DGROUP		; (test program is small model)

	lea	si,logo_text
	call	puts

	call	netbios_check
	jc	mai3			;  if no netbios driver

	lea	si,low_iq_server_text	; *Low IQ Server*
	call	netbios_add_name
	jc	mai5			;  if add name failed
	mov	add_name,al

mai1:	lea	si,listen_ncb		; build listen control block
	call	clear_ncb

	mov	Ncb_Command[si],NB_LISTEN
	mov	Ncb_CallName[si],'*'	;  (accept CALLs from anyone)

	lea	si,low_iq_server_text	;  enter server name
	lea	di,listen_ncb.Ncb_Name
	call	strcpy

	lea	si,listen_ncb
	mov	Ncb_Rto[si],-1 ;4*2	;  receive  timeout is 4 seconds
	mov	Ncb_Sto[si],-1 ;30*2	;  transmit timeout is 30 seconds

	call	netbios_call		; begin listening for client
	jc	mai6			;  if error posting listen command

mai2:	call	get_input_state
	jnz	mai7			;  if keyboard exit request
	mov	al,Ncb_Cmd_Cplt[si]
	cmp	al,0FFh
	je	mai2			;  if listen still pending
	cmp	al,0
	jne	mai6			;  if listen failed

	mov	al,Ncb_Lsn[si]		; save session number
	mov	session_number,al

	lea	di,position_req		; get transfer request from client
	mov	cx,size position_req+size length_req+1+size filename_req
	call	netbios_receive_wait	;  (AL is session)
	jc	mai10			;  if unexpected error

	cmp	direction_flag,'r'	; check request code
	jne	mai12			;  if not read file

	call	process_read_request	;  else transfer file to client
	jnc	mai1			;  if no errors, continue

mai3:	lea	si,ertx_driver		; *No NetBIOS driver*
mai4:	call	puts
	jmp	exit_program

mai5:	lea	si,ertx_add_name	; *ADD NAME error*
	jmp	mai4

mai6:	lea	si,ertx_listen		; *LISTEN error*
	jmp	mai8

mai7:	lea	si,listen_ncb
	call	netbios_cancel
	lea	si,exiting_text		; *Exiting*

mai8:	call	puts
mai9:	lea	si,low_iq_server_text
	call	netbios_delete_name
	jmp	exit_program

mai10:	lea	si,ertx_receive		; *RECEIVE error*
mai11:	call	puts
	mov	al,session_number
	call	netbios_hang_up
	jmp	mai9

mai12:	lea	si,ertx_read_only	; *Server only supports read requests*
	jmp	mai11
main	endp


;;	process read request
;
;	entry	DS	DGROUP
;	uses	AX,BX,CX,DX,SI,DI
;
process_read_request proc
	assume	ds:DGROUP		; (test program is small model)

	lea	si,filename_req		; open requested file
	call	open_input_file
	jc	prr2			;  if file not found

	mov	ax,wptr position_req	; set file position
	mov	dx,wptr position_req+2
	call	move_file_pointer

prr1:	mov	cx,size file_buffer	; choose transfer size
	mov	ax,wptr length_req
	mov	dx,wptr length_req+2
	call	select_min_count
	jcxz	prr5			;  if length limit reached

	lea	di,file_buffer		; read file data
	call	read_from_file
	jc	prr3			;  if file read error
	mov	cx,ax
	jcxz	prr5			;  if end of file

	sub	wptr length_req,cx	; update transfer limit
	sbb	wptr length_req+2,ZER0

	mov	al,session_number	; send file data to client
	call	netbios_send_wait	;  (ES:DI->file_buffer)
	jnc	prr1			;  if OK, continue transfer

	lea	si,ertx_send		; *SEND error*
	jmp	prr4

prr2:	lea	si,ertx_file_not_found	; *File not found*
	jmp	prr4

prr3:	lea	si,ertx_read		; *File read error*
prr4:	call	puts
	stc
	ret

prr5:	call	close_file		; close file and hang up session at
	mov	al,session_number	;   end of file or when requested
	call	netbios_hang_up		;   transfer count
	ret
process_read_request endp

	end
