/*	v_close.c- Remove Viewport from Screen Permanantly */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_close( viewport *v )
{
    /* Close the viewport (set it back to a pristine condition). The
     * underlying text is restored if it was saved by v_open. Any
     * old image (as is saved by v_deactivate()) is discarded.
     */

    if( v->magic != VMAGIC )
        return 0;

    if( v->old_image )                  /* If window is inactive,       */
        VFREE( v->old_image );          /* free the old image           */

    if( v->savebuf )                    /* and restore original text.   */
    {
        _v_restore_scr( v->savebuf, v->row, v->col, v->nrows, v->ncols );
        VFREE( v->savebuf );
        v->savebuf = NULL;
    }
    v->closed   = 1;
    v->inactive = 1;
    return 1;
}
