/*	v_move.c- Move Viewport */

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <tools/viewport.h>

int v_move( viewport *v, unsigned row, unsigned col )
{
    /* Move the viewport to indicated absolute row and column. The
     * viewport must be closed or hidden to move it. If the viewport
     * is open and active, it's deactivated, moved, then reopened.
     * You may not move the viewport past the edge of the screen.
     * Return true if the viewport ended up where specified, false if
     * it bumped up against the side of the screen.
     */

    int              rval       = 1 ;   /* return value */
    int              was_active = !v->inactive;
    struct text_info info;

    if( v->magic != VMAGIC )
        return 0;

    gettextinfo( &info );

    if( row+v->nrows > info.screenheight  )     /* Truncate row and col */
    {                                           /* so that the viewport */
        row = info.screenheight - v->nrows ;    /* stays on the screen. */
        rval = 0;
    }
    if( col+v->ncols > info.screenwidth )
    {
        col = info.screenwidth - v->ncols ;
        rval = 0;
    }

    if( was_active )
        v_deactivate( v, 1 );

    v->row = row;
    v->col = col;

    if( was_active )
        v_open( v );

    return rval;
}
