/* window.h-- High-Level Window Definitions */


#ifndef __WINDOW_H
#define __WINDOW_H

#include <tools/textbuf.h>      /* textbuf definition.  */
#include <tools/viewport.h>     /* engine definition.   */

#define ETYP struct win
#include <tools/editor.h>       /* Customize editor.h prototypes  */
                                /* for use in a window.           */
#define W_LINEMAX E_LINEMAX

typedef struct win
{
    editor e;           /* Variables for engine maintenance      */
                        /* This would be the base class in a C++ */
                        /* implementation. THIS MUST BE THE AT   */
                        /* THE TOP OF THE STRUCTURE BECAUSE IT'S */
                        /* USED POLYMORPHICALLY BY THE EDITOR.   */

    textbuf  b;         /* Text buffer and viewport.              */
    viewport v;         /* (instance variables, not base classes) */

    unsigned row_off;  /* Offset to upper-left corner of textbuf   */
    unsigned col_off;  /*        to upper-left corner of viewport  */
    unsigned file_off; /* Offset from top of file to top of buffer.*/
                       /* initially zero, Incremented on a success-*/
                       /* ful import when text scrolls up. Decre-  */
                       /* mented on import when text scrolls down. */
                       /* I'm assuming that text is positioned     */
                       /* initially at the top of the file, so     */
                       /* it's an error if you try to scroll text  */
                       /* down and file_off==0.                    */
    int bottom;        /* Line number of bottom line in file. -1   */
                       /* if the file is empty.                    */

    unsigned update_row_off;  /* Position when screen updating is  */
    unsigned update_col_off;  /* disabled                          */
    unsigned update_file_off;
    unsigned update_row;
    unsigned update_col;

    unsigned update : 1; /* Viewport updating is enabled.          */
    unsigned dirty  : 1; /* file modified when updating disabled.  */
    unsigned error  : 1; /* error has occurred at some point.      */

    unsigned engine_active : 1; /* Editing engine initialized      */

    char *(*import)( struct win *this, int lnum );
    int   (*insert)( struct win *this, int lnum );
    void  (*export)( struct win *this, int lnum, char *line,
                                                int nc, int len );
    void  (*remove)( struct win *this, int lnum, char *line,
                                                int nc, int len );
}
win;

win *w_construct ( int win_height, int win_width );
void w_destroy   ( win *w );
void w_open      ( win *w );
void w_hide      ( win *w );
void w_viewsize  ( win *w, int view_height, int view_width );
void w_viewcolor ( win *w, int foreground, int background );
void w_move_rel  ( win *w, int delta_row, int delta_col );
void w_move      ( win *w, int row, int col );
void wputc       ( win *w, int c );
void w_file      ( win *w,
    char *(*import)( win *this,int lnum ),
    int   (*insert)( win *this,int lnum ),
    void  (*export)( win *this,int lnum, char* line,int nc,int len),
    void  (*remove)( win *this,int lnum, char* line,int nc,int len)
                 );

#endif /* __WINDOW_H */
