CSEG     SEGMENT BYTE PUBLIC 'CODE'
         ASSUME  CS:CSEG,DS:CSEG,ES:CSEG,SS:CSEG
         PUBLIC  LPLK10
         PUBLIC  LOK10
         PUBLIC  UNLOK10
LOOPLOCK EQU     11H               ; 3COM LOCK WITH DELAY
LOCK     EQU     12H               ; 3COM LOCK WITH RETURN
UNLOCK   EQU     13H               ; 3COM UNLOCK
REQUEST  DB      ?                 ; TYPE OF REQUEST
DRIVE    DB      ?                 ; INPUT DRIVE NUMBER
DELAY    DW      ?                 ; DELAY TIME
ENET     DW      0                 ; DUMMY ETHERNET ADDRESS
LENLOK   DW      ?                 ; LENGTH OF LOCK NAME
POINTER  DW      ?                 ; POINTER TO LOCK NAME
LOCKNAME DB      31 DUP(?)         ; INPUT LOCK NAME
         DB      0                 ; TERMINATOR
LPLK10   PROC    FAR
         MOV     CS:REQUEST,LOOPLOCK
         MOV     CS:DELAY,300      ; WAIT 5 MINUTES FOR LOCK
         JMP     PROCESS
LPLK10   ENDP
LOK10    PROC    FAR
         MOV     CS:REQUEST,LOCK
         MOV     CS:DELAY,10       ; WAIT 10 SECONDS FOR LOCK
         JMP     PROCESS
LOK10    ENDP
UNLOK10  PROC    FAR
         MOV     CS:REQUEST,UNLOCK
         MOV     CS:DELAY,0
PROCESS:
         PUSH    BP                ; SAVE BP
         MOV     BP,SP             ; SAVE SP INTO BP FOR PARM ADDRESSING
         PUSH    DS                ; SAVE BASIC'S DATA SEGMENT
         PUSH    ES                ; SAVE BASIC'S EXTRA SEGMENT
         MOV     BX,[BP+8]         ; GET ADDRESS OF STRING DESCRIPTOR
         MOV     DX,[BX+2]         ; GET ADDRESS OF STRING
         MOV     CS:POINTER,DX     ; SAVE POINTER TO STRING
         MOV     CX,[BX]           ; GET LENGTH OF STRING
         MOV     CS:LENLOK,CX      ; SAVE LENGTH OF THE STRING
         MOV     BX,[BP+10]        ; GET ADDRESS OF DRIVE NUMBER
         MOV     AL,[BX]           ; GET LOW ORDER BYTE OF DRIVE ADDRESS
         INC     AX                ; ADJUST DRIVE NUMBER
         MOV     CS:DRIVE,AL       ; SAVE THE DRIVE NUMBER
         PUSH    CS                ; MOV CS TO ES VIA STACK
         POP     ES                ; TARGET IS IN OUR CSEG
         MOV     SI,DX             ; OFFSET OF BASIC'S STRING
         MOV     DI,OFFSET LOCKNAME; OFFSET OF WORK AREA
         CLD                       ; START FROM THE BOTTOM
         REP     MOVSB             ; COPY BASIC'S STRING TO OUR WORK AREA
         PUSH    CS                ; MOV CS TO DS VIA STACK
         POP     DS                ; OUR CSEG SEGMENT INTO DS
         MOV     BX,OFFSET LOCKNAME+2 ; POINT TO NEW NAME
         MOV     SI,OFFSET ENET    ; POINT TO DUMMY ETHERNET ADDRESS
         MOV     AL,DRIVE          ; GET DRIVE FOR LOCK
         MOV     AH,REQUEST        ; RETRIEVE LOCK REQUEST TYPE
         MOV     DX,DELAY          ; 3COM DELAY TIME
         INT     60H               ; CALL 3COM LOCK MANAGER
         POP     ES                ; GET BACK BASIC'S EXTRA SEGMENT
         POP     DS                ; GET BACK BASIC'S DATA SEGMENT
         MOV     DI,[BP+6]         ; GET ADDRESS OF RESULT VARIABLE
         MOV     [DI],AL           ; STORE RETURN CODE FROM LOCK MANAGER
         POP     BP
         RET     6
UNLOK10  ENDP
CSEG     ENDS
         END
