/********************************************************************
*	This is a small C routine used to call an assembly function
* which changes the hardware border on your monitor.
*
* Written By: Gary L. Hennigan <ghenniga@NMSU.Edu>
*	      New Mexico State University
*	      Las Cruces, NM
*
* Date: 11/28/90
*
* Note that in it's current form the program only accepts 0-15 as
* it's input, for CGA compatibility, it could also easily accept
* 0-63 if you have an EGA compatible monitor.
*********************************************************************
* Function Used:
*	   	  bord_change (ASM) - Function which uses the BIOS
*				      to change the border color.
*********************************************************************
* Variable Used:
*		  brd_color (int) - the value to change the border
*				    color to.
********************************************************************/
#include <stdio.h>

/*
 * MXCOLOR defines the maximum color the border can be set to. For
 * a CGA and compatible this is 15 while for an EGA/VGA it is 63.
 */
#define MXCOLOR 15

extern void bord_change( int );

main( int argc, char *argv[] )
{
   int brd_color=0, delay, i, j;

   if( argc <= 1 ){
      printf( "\nEnter a number from 0-15 indicating which border color you wish to use. The");
      printf( "\nresults will vary depending on how software has set up the color pallette but ");
      printf( "\nhere's how they correspond on a PS/2 Model 55 with VGA, 80 column text mode,");
      printf( "\nand the default pallette:");
      printf( "\n     0 - Black      5 - Purple      10 - Bright Green     15 - Light Cyan" );
      printf( "\n     1 - Blue       6 - Yellow      11 - Light Cyan" );
      printf( "\n     2 - Green      7 - White       12 - Orange" );
      printf( "\n     3 - Cyan       8 - Dark Green  13 - Purple");
      printf( "\n     4 - Red        9 - Light Blue  14 - Green");
      printf( "\nChoice: ");
      scanf( "%d", &brd_color );
   }
   else{
      sscanf( argv[1], "%d", &brd_color );
      bord_change( brd_color );
   }

   while( brd_color < 0 || brd_color > MXCOLOR ){
      printf("\n\aInvalid Entry! Please Enter a number between 0 and 15: ");
      scanf("%d", &brd_color);
   }
   bord_change( brd_color );

   return 1;
}
