/*
 *
 * This is a test program for the PDCurses screen package for IBM PC type
 * machines.
 * This program was written by John Burnell (johnb@kea.am.dsir.govt.nz)
 * To compile this program with your compiler define or leave undefined
 * the following preprocessor macros:
 * PROTO - define if your compiler accepts standard ANSI-C function prototypes
 * COLOR_CURSES - define if your curses library has color support
 *
 */
#define PROTO
#define COLOR_CURSES

#include <stdio.h>
#include <curses.h>

#ifdef PROTO
void inputTest (WINDOW *win);
void scrollTest (WINDOW *win, int height, int width);
int introTest (WINDOW *win);
int initTest (WINDOW **win, int *height, int *width);
void outputTest (WINDOW *win);
void padTest (void);
void resizeTest (void);
#else
void inputTest ();
void scrollTest ();
int introTest ();
int initTest ();
void outputTest ();
void padTest ();
void resizeTest ();
#endif

main()
{
WINDOW  *win;
int     width, height;

    if (!initTest (&win, &height, &width)) {return 1;}

    padTest ();

    introTest (win);

    resizeTest ();

    scrollTest (win, height, width);

    inputTest (win);

    outputTest (win);

    delwin (win);

    endwin();
    return 0;
}
#ifdef PROTO
void Continue (WINDOW *win)
#else
void Continue (win)
WINDOW *win;
#endif
{
    wmove(win, 10, 1);
    wclrtoeol(win);
    mvwaddstr(win, 10, 1, " Press any key to continue");
    wrefresh(win);
    raw();
    wgetch(win);
}
#ifdef PROTO
int initTest (WINDOW **win, int *height, int *width)
#else
int initTest (win, height, width)
WINDOW **win;
int *height;
int *width;
#endif
{
    initscr();
#ifdef COLOR_CURSES
    if (has_colors())
       start_color();
#endif
    *width  = 60;
    *height = 13;                /* Create a drawing window */
    *win = newwin(*height, *width, (LINES-*height)/2, (COLS-*width)/2);
    if(*win == NULL)
    {   endwin();
        return 1;
    }
}
#ifdef PROTO
int introTest (WINDOW *win)
#else
int introTest (win)
WINDOW *win;
#endif
{
    beep ();
#ifdef COLOR_CURSES
    if (has_colors())
       init_pair(1,COLOR_WHITE,COLOR_BLUE);
    wattrset(win, COLOR_PAIR(1));
#else
    wattrset(win, A_REVERSE);
#endif
    werase(win);

    box(win, 0xba, 0xcd);
    wrefresh(win);
    cbreak ();
    mvwaddstr(win, 1, 1, "You should have rectangle in the middle of the screen");
    mvwaddstr(win, 2, 1, "You should have heard a beep");
    Continue(win);
    return 1;
}
#ifdef PROTO
void scrollTest (WINDOW *win, int height, int width)
#else
void scrollTest (win, height, width)
WINDOW *win;
int height,width;
#endif
{
    int i;
    int OldX, OldY;
    char *Message = "The window will now scroll slowly";

    mvwprintw (win, height - 2, 1, Message);
    wrefresh (win);
    scrollok(win, TRUE);
    for (i = 1; i <= height; i++) {
      delay_output (250);
      scroll(win);
      wrefresh (win);
    };

    getmaxyx (win, OldY, OldX);
    mvwprintw (win, 6, 1, "The top of the window will scroll");
    wmove (win, 1, 1);
    wsetscrreg (win, 0, 4);
    box(win, 0xba, 0xcd);
    wrefresh (win);
    for (i = 1; i <= 5; i++) {
      delay_output (500);
      scroll(win);
      wrefresh (win);
    };
    wsetscrreg (win, 0, --OldY);

}
#ifdef PROTO
void inputTest (WINDOW *win)
#else
void inputTest (win)
WINDOW *win;
#endif
{
    int w, h, bx, by, sw, sh, i, c;
    char buffer [80];
    WINDOW *subWin;
    wclear (win);

    w  = win->_maxx;
    h  = win->_maxy;
    bx = win->_begx;
    by = win->_begy;
    sw = w / 3;
    sh = h / 3;
    if((subWin = subwin(win, sh, sw, by + h - sh - 2, bx + w - sw - 2)) == NULL)
        return;

#ifdef COLOR_CURSES
    if (has_colors())
       init_pair(2,COLOR_CYAN,COLOR_BLUE);
    wattrset(subWin, COLOR_PAIR(2) | A_BOLD);
#else
    wattrset(subWin, A_BOLD);
#endif
    box(subWin, 0xba, 0xcd);
    wrefresh(win);

    nocbreak();
    mvwaddstr(win, 2, 1, "Press some keys for 5 seconds");
    mvwaddstr(win, 1, 1, "Pressing ^C should do nothing");
    wrefresh(win);

    for (i = 0; i < 5; i++) {
      werase (subWin);
      box(subWin, 0xba, 0xcd);
      mvwprintw (subWin, 1, 1, "Time = %d", i);
      wrefresh(subWin);
      delay_output(1000);
      flushinp();
    }

    delwin (subWin);
    werase(win);
    flash();
    wrefresh(win);
    delay_output(500);

    if (typeahead(NULL)) beep();
    mvwaddstr(win, 2, 1, "Press a key, followed by ENTER");
    wmove(win, 9, 10);
    wrefresh(win);
    echo();
    noraw();
    wgetch(win);
    flushinp();

    wmove(win, 9, 10);
    wdelch(win);
    mvwaddstr(win, 4, 1, "The character should now have been deleted");
    Continue(win);

    wclear (win);
    mvwaddstr(win, 2, 1, "Press an arrow key");
    wrefresh(win);
    keypad(win, TRUE);
    raw();
    c = wgetch(win);

    nodelay(win, TRUE);
    wgetch(win);
    nodelay(win, FALSE);

    refresh();
    wclear (win);
    mvwaddstr(win, 3, 2, "The window should have moved");
    mvwaddstr(win, 4, 2, "This text should have appeared without you pressing a key");
    mvwprintw(win, 2, 2, "Keycode = %d", c);
    mvwaddstr(win, 6, 2, "Enter a string");
    mvwin(win, 2, 1);
    wrefresh(win);
    mvwscanw(win, 7, 6, "%s", buffer);
}
#ifdef PROTO
void outputTest (WINDOW *win)
#else
void outputTest (win)
WINDOW *win;
#endif
{
    WINDOW *win1;
    char Buffer [80];
    chtype ch;

    nl ();
    wclear (win);
    mvwaddstr(win, 1, 1, "You should now have a screen in the upper left corner, and this text should have wrapped");
    Continue(win);

    wclear(win);
    mvwaddstr(win, 1, 1, "A new window will appear with this text in it");
    mvwaddstr(win, 8, 1, "Press any key to continue");
    wrefresh(win);
    wgetch(win);

    win1 = newwin(10, 50, 15, 25);
    if(win1 == NULL)
    {   endwin();
        return;
    }
#ifdef COLOR_CURSES
    if (has_colors())
       init_pair(3,COLOR_BLUE,COLOR_WHITE);
    wattrset(win1, COLOR_PAIR(3));
#else
    wattrset(win1, A_NORMAL);
#endif
    wclear (win1);
    mvwaddstr(win1, 5, 1, "This text should not appear");
    overwrite(win, win1);

    box(win1,0xb3,0xc4);
    wmove(win1, 8, 26);
    wrefresh(win1);
    wgetch(win1);

    wclear(win1);
    wattron(win1, A_BLINK);
    mvwaddstr(win1, 4, 1, "This blinking text should appear in only the second window");
    wattroff(win1, A_BLINK);
    overlay(win, win1);
    wmove(win1, 8, 26);
    wrefresh(win1);
    wgetch(win1);
    delwin(win1);

    clear();
    wclear(win);
    wrefresh(win);
    mvwaddstr(win, 6, 2, "This line shouldn't appear");
    mvwaddstr(win, 4, 2, "Only half of the next line is visible");
    mvwaddstr(win, 5, 2, "Only half of the next line is visible");
    wmove(win, 6, 1);
    wclrtobot (win);
    wmove(win, 5, 20);
    wclrtoeol (win);
    mvwaddstr(win, 8, 2, "This line also shouldn't appear");
    wmove(win, 8, 1);
    wdeleteln(win);
    Continue(win);

    wmove (win, 5, 9);
    ch = winch (win);

    wclear(win);
    wmove (win, 6, 2);
    waddstr (win, "The next char should be l:  ");
    winsch (win, ch);
    Continue(win);

    wmove(win, 5, 1);
    winsertln (win);
    mvwaddstr(win, 5, 2, "The lines below should have moved down");
    Continue(win);

    wclear(win);
    wmove(win, 2, 2);
    wprintw(win, "This is a formatted string in a window: %d %s\n", 42, "is it");
    mvwaddstr(win, 10, 1, "Enter a string: ");
    wrefresh(win);
    wscanw (win, "%s", Buffer);

    wclear(win);
    mvwaddstr(win, 10, 1, "Enter a string");
    wrefresh(win);
    printw("This is a formatted string in stdscr: %d %s\n", 42, "is it");
    scanw ("%s", Buffer);

    wclear(win);
    curs_set(2);
    mvwaddstr(win, 1, 1, "The cursor should appear as a block");
    Continue(win);

    wclear(win);
    curs_set(0);
    mvwaddstr(win, 1, 1, "The cursor should have disappeared");
    Continue(win);

    wclear(win);
    curs_set(1);
    mvwaddstr(win, 1, 1, "The cursor should be an underline");
    Continue(win);
}

#ifdef PROTO
void resizeTest(void)
#else
void resizeTest()
#endif
{
    WINDOW *win1;
    char Buffer [80];
    chtype ch;

    savetty ();

    clear();
    refresh();
    resize(50);


    win1 = newwin(11, 50, 14, 25);
    if(win1 == NULL)
    {   endwin();
        return;
    }
    init_pair(3,COLOR_BLUE,COLOR_WHITE);
    wattrset(win1, COLOR_PAIR(3));
    wclear (win1);

    mvwaddstr(win1, 1, 1, "The screen may now have 50 lines");
    Continue(win1);

    resetty ();

    wclear (win1);
    mvwaddstr(win1, 1, 1, "The screen should now be reset");
    Continue(win1);

    delwin(win1);

    clear();
    refresh();

}
#ifdef PROTO
void padTest(void)
#else
void padTest()
#endif
{
WINDOW *pad;

 pad = newpad(50,100);
 mvwaddstr(pad, 5, 2, "This is a new pad");
 mvwaddstr(pad, 8, 0, "The end of this line should be truncated here:abcd");
 mvwaddstr(pad,11, 1, "This line should not appear.");
 wmove(pad, 10, 1);
 wclrtoeol(pad);
 mvwaddstr(pad, 10, 1, " Press any key to continue");
 prefresh(pad,0,0,0,0,10,45);
 keypad(pad, TRUE);
 raw();
 wgetch(pad);

 mvwaddstr(pad, 35, 2, "This is displayed at line 35 in the pad");
 mvwaddstr(pad, 40, 1, " Press any key to continue");
 prefresh(pad,30,0,0,0,10,45);
 keypad(pad, TRUE);
 raw();
 wgetch(pad);

 delwin(pad);
}

