#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	resize_win

#ifndef NDEBUG
char *rcsid_resizew = "$Header: c:/curses/nonport/RCS/resizew.c%v 2.0 1992/11/15 03:18:28 MH Rel $";
#endif




/*man-start*********************************************************************

  resize_win()	-	Resize a window

  PDCurses Description:
 	Resizes the passed WINDOW* to reflect the maximum size
 	represented by the WINDOW* fields _pmaxy and _pmaxx.

 	If _maxy < _pmaxy then new lines will be added.
 	The same is also true for _maxx and _pmaxx.

 	WARNING TO PROGRAMMERS:

 	This function assumes that when a window is enlarged
 	horizontally, the contents on each existing line will be
 	copied to the new, enlarged line and the remainder of the
 	enlarged line will be cleared.

 	When a window is enlarged vertically, each new line added
 	will be blank.

 	All borders will be observed and enlarged appropriately.

 	When a windows are shrunk, only the WINDOW* fields _pmaxy and
 	_pmaxx are affected.

  PDCurses Return Value:
 	The resize_win() function returns a NULL pointer or a valid
 	WINDOW* which may or may not point to the same physical
 	window.  Besure to change all pointers to the passed window
 	to the address returned by this function (but only if it is
 	non-zero).

  PDCurses Errors:
 	It is an error to pass a NULL WINDOW pointer.

  Portability:
 	PDCurses	WINDOW*	resize_win( WINDOW* w, int lines, int cols );

**man-end**********************************************************************/

WINDOW*	resize_win(WINDOW *w, int lines, int cols)
{
extern	void*	(*mallc)();	/* ptr to some malloc(size)	*/
extern	void*	(*callc)();	/* ptr to some ecalloc(num,size)*/
extern	void	(*fre)();	/* ptr to some free(ptr)	*/

	WINDOW*	new;
	int	ncols  = max(cols, w->_pmaxx);
	int	nlines = max(lines, w->_pmaxy);
	int	i;
	int	j;

	if (w == (WINDOW *)NULL)
		return( (WINDOW *)NULL );

	if ((lines > w->_pmaxy) || (cols > w->_pmaxx))
	{
		if ((new = PDC_makenew(nlines, ncols, w->_begy, w->_begx)) == (WINDOW *)NULL)
			return( (WINDOW *)NULL );

		new->_curx = w->_curx;
		new->_cury = w->_cury;
		new->_flags = w->_flags;
		new->_attrs = w->_attrs;
		new->_tabsize = w->_tabsize;
		new->_clear = w->_clear;
		new->_leave = w->_leave;
		new->_scroll = w->_scroll;
		new->_nodelay = w->_nodelay;
		new->_use_keypad = w->_use_keypad;
		new->_tmarg = w->_tmarg;
		new->_bmarg = w->_bmarg;
		new->_title = w->_title;
		new->_title_ofs = w->_title_ofs;
		new->_title_attr = w->_title_attr;
		new->_parent = w->_parent;
		memcpy(new->_borderchars, w->_borderchars, 8*sizeof(chtype));

		for (i = 0; i < nlines; i++)
		{
			/*
			 * make and clear the lines
			 */
			if ((new->_y[i] = (chtype*)(*callc)(ncols, sizeof(chtype))) == NULL)
			{
				for (j = 0; j < i; j++)
				{
					/*
					 * if error, free all the data
					 */
					(*fre)(new->_y[j]);
				}
				(*fre)(new->_firstch);
				(*fre)(new->_lastch);
				(*fre)(new->_y);
				(*fre)(new);
				return( (WINDOW *)NULL );
			}
		}
		if ((w != curscr) && (w != tmpwin))
		{
			overwrite(w, new);
			wmove(new, w->_maxy - 1, 0);
			wclrtobot(new);
/* JGB box uses defaults if arguments are zero, but we don't want to do
   this if the window currently has no box */
			if (w->_borderchars[0] || w->_borderchars[2])
				box(new, w->_borderchars[0], w->_borderchars[2]);
		}
		delwin(w);
		return( new );
	}
	else
	{
		w->_bmarg = lines - 1;
		w->_maxy = lines;
		w->_maxx = cols;
/* JGB box uses defaults if arguments are zero, but we don't want to do
   this if the window currently has no box */
		if (w->_borderchars[0] || w->_borderchars[2])
			box(w, w->_borderchars[0], w->_borderchars[2]);
		return( w );
	}
}
