#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	doupdate

#ifndef	NDEBUG
char *rcsid_doupdate = "$Header: c:/curses/portable/RCS/doupdate.c%v 2.0 1992/11/15 03:28:50 MH Rel $";
#endif

WINDOW *twin;			/* used by many routines */


/*man-start*********************************************************************

  doupdate()	- do effiecient refresh

  X/Open Description: (part of the wnoutrefresh() description.)
 	These two routines allow multiple updates with more efficiency
 	than wrefresh() alone.  In addition to all of the window
 	structures representing the terminal screen: a physical screen,
 	describing what is actually on the screen and a virtual screen,
 	describing what the programmer wants to have on  the screen.

 	The wrefresh() function works by first calling wnoutrefresh(),
 	which copies the named window to the virtual screen.  It then
 	calls doupdate(), which compares the virtual screen to the
 	physical screen and does the actual update.  If the programmer
 	wishes to output several windows at once, a series of cals to
 	wrefresh() will result in alternating calls to wnoutrefresh()
 	and doupdate(), causing several bursts of output to the
 	screen.  By first calling wnoutrefresh() for each window, it
 	is then possible to call doupdate() once.  This results in
 	only one burst of output, with probably fewer total characters
 	transmitted and certainly less CPU time used.

  PDCurses Description:
 	In addition to the above, if REGISTERWINDOWS is TRUE when the
 	library was compiled, any windows registered (true by default
 	with PDCurses and _cursvar.refreshall is TRUE, then all
 	registered windows will be called via wnoutrefresh() before
 	the actual screen update begins.

  X/Open Return Value:
 	The doupdate() function returns OK on success and ERR on error.

  X/Open Errors:
 	No errors are defined for this function.

  Portability:
 	PDCurses	int doupdate( void );
 	X/Open Dec '88	int doupdate( void );
 	BSD Curses	int doupdate( void );
 	SYS V Curses	int doupdate( void );

**man-end**********************************************************************/

int	doupdate(void)
{
register int	i;
#ifdef	REGISTERWINDOWS
	WINDS*	next = _cursvar.visible;

	if (_cursvar.refreshall)
	{
		while (next != NULL)
		{
			if (next->w->_parent != NULL)
			{
				touchwin(next->w->_parent);
				wnoutrefresh(next->w->_parent);
			}
			touchwin(next->w);
			wnoutrefresh(next->w);
			next = next->next;
		}
	}
#endif
	if  (_cursvar.shell)
		reset_prog_mode();

	twin = tmpwin;
	if (twin == (WINDOW *)NULL)
		return( ERR );

	if (curscr->_clear)
	{
		PDC_clr_update(curscr);
	}
	else
	{
		if (twin->_clear)
		{
			PDC_clr_update(twin);
		}
		else
		{
			for (i = 0; i < LINES; i++)
			{
				if (twin->_firstch[i] != _NO_CHANGE)
					if (PDC_transform_line(i))
						break;
			}
		}
	}
	curscr->_curx = twin->_curx;
	curscr->_cury = twin->_cury;
	PDC_gotoxy(curscr->_cury, curscr->_curx);
	return( OK );
}
