#ifndef NO_MEMORY_H
#include <memory.h>
#endif
#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	pnoutrefresh

#ifndef	NDEBUG
char *rcsid_pnoutref = "$Header: c:/curses/portable/RCS/pnoutref.c%v 2.0 1992/11/15 03:29:14 MH Rel $";
#endif




/*man-start*********************************************************************

  pnoutrefresh()	- refresh pad without updating physical screen

  X/Open Description:
 	The prefresh routine copies the specified pad to the physical
 	terminal screen.  It takes account of what is already
 	displayed on the screen to optimize cursor movement.

 	The pnoutrefresh routine copies the named pad to the virtual
 	screen. It then compares the virtual screen with the physical
 	screen and performs the actual update.

 	These routines are analogous to the routines wrefresh and
 	wnoutrefresh except that pads, instead of windows, are
 	involved.  Additional parameters are also needed to indicate
 	what part of the pad and screen are involved. The upper left
 	corner of the part of the pad to be displayed is specified by
 	py and px.  The coordinates sy1, sx1, sy2, and sx2 specify the
 	edges of the screen rectangle that will contain the selected
 	part of the pad.

 	The lower right corner of the pad rectangle to be displayed is
 	calculated from the screen co-ordinates.  This ensures that
 	the screen rectangle and the pad rectangle are the same size.

 	Both rectangles must be entirely contained within their
 	respective structures.

  PDCurses Description:
 	Contrary to the statements above, the pnoutrefresh() routine
 	will not perform an update to the physical screen.  This task
 	is performed by doupdate().

  X/Open Return Value:
 	The prefresh() function returns OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to pass a null WINDOW* pointer.

  Portability:
 	PDCurses	int pnoutrefresh( WINDOW* w, int py, int px,
 						int sy1, int sx1,
 						int sy2, int sx2 );
 	X/Open Dec '88	int pnoutrefresh( WINDOW* win, int py, int px,
 						int sy1, int sx1,
 						int sy2, int sx2 );
 	BSD Curses	int pnoutrefresh( WINDOW* w, int pminrow, int pmincol,
 						int sminrow, int smincol,
 						int smaxrow, int smaxcol );
 	SYS V Curses	int pnoutrefresh( WINDOW* win, int py, int px,
 						int sy1, int sx1,
 						int sy2, int sx2 );

**man-end**********************************************************************/

int	pnoutrefresh(WINDOW* w,int py,int px,int sy1,int sx1,int sy2,int sx2)
{
register chtype*	dstp;
register chtype*	srcp;
	WINDOW*		s = tmpwin;
	int		sline = sy1;
	int		pline = py;


	if (w == (WINDOW *)NULL)
		return( ERR );

	while (sline <= sy2)
	{
		if (pline < w->_maxy)
		{
#if 	defined(DOS) || defined(OS2)
#  if	SMALL || MEDIUM
			srcp = &(w->_y[pline][px]);
			dstp = &(s->_y[sline][sx1]);
			movedata(FP_SEG(srcp), FP_OFF(srcp),
				 FP_SEG(dstp), FP_OFF(dstp),
				 (sx2 - sx1 + 1) * sizeof(chtype));
#  else
			memcpy(&(s->_y[sline][sx1]),
			       &(w->_y[pline][px]),
			       (sx2 - sx1 + 1) * sizeof(chtype));
#  endif
#endif

			if ((s->_firstch[sline] == _NO_CHANGE) ||
			    (s->_firstch[sline] > sx1))
			{
				s->_firstch[sline] = sx1;
			}

			if (sx2 > s->_lastch[sline])
				s->_lastch[sline] = sx2;

			w->_firstch[pline] = _NO_CHANGE;  /* updated now */
			w->_lastch[pline] = _NO_CHANGE;  /* updated now */
		}
		sline++;
		pline++;
	}

	if (w->_clear)
	{
		w->_clear = FALSE;
		s->_clear = TRUE;
	}
	return( OK );
}
