#define CURSES_LIBRARY	1
#include <curses.h>
#undef  raw

#ifndef NDEBUG
char *rcsid_raw = "$Header: c:/curses/portable/RCS/raw.c%v 2.0 1992/11/15 03:29:25 MH Rel $";
#endif




/*man-start*********************************************************************

  raw()	- enable raw mode

  X/Open Description:
        The terminal in placed into or out of raw mode.  Raw mode is
        similar to cbreak mode, in that characters typed are immediately
        passed through to the user program.  The differences are that in
        raw mode, the INTR, QUIT, SUSP, and STOP characters are passed
        through without being interpreted, and without generating a
        signal.  The behaviour of the BREAK key depends on other
        parameters of the terminal drive that are not set by curses.

  PDCurses Description:
        Raw mode in the traditional sense refers to input handling.
        Contrast raw_output() which enables 8bit characters.

        FYI:	PDCurses does NOT provide signal(3) support,
 		this must be done by the application.

  X/Open Return Value:
        This function returns OK on success and ERR on error.

  X/Open Errors:
        No errors are defined for this function.

  Portability:
        PDCurses        int raw( void );
        X/Open Dec '88  int raw( void );
        BSD Curses      int raw( void );
        SYS V Curses    int raw( void );

**man-end**********************************************************************/

int     raw(void)
{
#ifdef OS2
	KBDINFO KbdInfo;

	KbdGetStatus(&KbdInfo,0);
	KbdInfo.fsMask |= KEYBOARD_BINARY_MODE;
	KbdInfo.fsMask &= ~KEYBOARD_ASCII_MODE;
	KbdSetStatus(&KbdInfo,0);
#endif
	_cursvar.raw_inp = TRUE;
	PDC_set_ctrl_break(FALSE);      /* disallow ^BREAK on disk I/O */
/*	flushinp(); */
	return( OK );
}
