#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wsetscrreg

#ifndef	NDEBUG
char *rcsid_wsetscrr = "$Header: c:/curses/portable/RCS/wsetscrr.c%v 2.0 1992/11/15 03:29:29 MH Rel $";
#endif




/*man-start*********************************************************************

  wsetscrreg()	- set scrolling region

  X/Open Description:	setscrreg(), wsetscrreg()
 	These functions allow the suer to set a software scrolling region
 	in a window.  The parameters 'top' and 'bot' are the line numbers
 	of the top and bottom margin of the scrolling region.  (Line 0 is
 	the top line of the window.)  If this option and scrollok() are
 	enabled, an attempt to move off the bottom margin will cause all
 	lines in the scrolling region to scroll up one line.  Only the
 	text of the window is scrolled.

  PDCurses Description:
 	PDCurses implements the standard OK and ERR return values.

 	FYI: setscrreg() is also defined as a macro.

  X/Open Return Value:
 	No return values are defined for these functions.

  PDCurses Errors:
 	It is an error to pass a NULL WINDOW pointer.
 	The top and bottom coordinates must be inside the passed window
 	and must bound the window's cursor position.  e.g.  The cursor
 	cannot be above or below the top or bottom margins.

  Portability:
 	PDCurses	int wsetscrreg( WINDOW* win, int top, int bottom );
 	X/Open Dec '88	int wsetscrreg( WINDOW* win, int top, int bottom );
 	SysV Curses	int wsetscrreg( WINDOW* win, int top, int bottom );
 	BSD Curses	int wsetscrreg( WINDOW* win, int top, int bottom );

**man-end**********************************************************************/

int	wsetscrreg(WINDOW *win, int top, int bottom)
{
	if (win == (WINDOW *)NULL)
		return (ERR);

	if ((0 <= top) &&
	    (top <= win->_cury) &&
	    (win->_cury <= bottom) &&
	    (bottom < win->_maxy))
	{
		win->_tmarg = top;
		win->_bmarg = bottom;
		return (OK);
	}
	else
	{
		return (ERR);
	}
}
