#define	CURSES_LIBRARY	1
#include <curses.h>

#ifndef	NDEBUG
char *rcsid__validch = "$Header: c:/curses/private/RCS/_validch.c%v 2.0 1992/11/15 03:24:39 MH Rel $";
#endif



/*man-start*********************************************************************

*	Table for key code translation of function keys in keypad mode
*	These values are for strict IBM keyboard compatibles only
**man-end**********************************************************************/


#if	defined (DOS) || defined (OS2)
static chtype kptab[] =
{
 /* Normal Function Keys	 */
 0x3b, KEY_F(1), 0x3c, KEY_F(2), 0x3d, KEY_F(3), 0x3e, KEY_F(4),
 0x3f, KEY_F(5), 0x40, KEY_F(6), 0x41, KEY_F(7), 0x42, KEY_F(8),
 0x43, KEY_F(9), 0x44, KEY_F(10),

 /* Normal Keypad		 */
 0x47, KEY_HOME, 0x48, KEY_UP,   0x49, KEY_PPAGE,
 0x4b, KEY_LEFT, 0x4c, KEY_B2,   0x4d, KEY_RIGHT,
 0x4f, KEY_END,  0x50, KEY_DOWN, 0x51, KEY_NPAGE,
 0x52, KEY_IC,   0x53, KEY_DC,

 /* Shft-Function Keys	 */
 0x54, KEY_F(11), 0x55, KEY_F(12), 0x56, KEY_F(13), 0x57, KEY_F(14),
 0x58, KEY_F(15), 0x59, KEY_F(16), 0x5a, KEY_F(17), 0x5b, KEY_F(18),
 0x5c, KEY_F(19), 0x5d, KEY_F(20),

 /* Ctl-Function Keys	 */
 0x5e, KEY_F(21), 0x5f, KEY_F(22), 0x60, KEY_F(23), 0x61, KEY_F(24),
 0x62, KEY_F(25), 0x63, KEY_F(26), 0x64, KEY_F(27), 0x65, KEY_F(28),
 0x66, KEY_F(29), 0x67, KEY_F(30),

 /* Alt-Function Keys	 */
 0x68, KEY_F(31), 0x69, KEY_F(32), 0x6a, KEY_F(33), 0x6b, KEY_F(34),
 0x6c, KEY_F(35), 0x6d, KEY_F(36), 0x6e, KEY_F(37), 0x6f, KEY_F(38),
 0x70, KEY_F(39), 0x71, KEY_F(40),

 /* Control-Keypad		 */
 0x77, CTL_HOME, 0x84, CTL_PGUP,
 0x73, CTL_LEFT, 0x74, CTL_RIGHT,
 0x75, CTL_END, 0x76, CTL_PGDN,

 /* Alt-Numbers		 */
 0x78, ALT_1, 0x79, ALT_2, 0x7a, ALT_3, 0x7b, ALT_4,
 0x7c, ALT_5, 0x7d, ALT_6, 0x7e, ALT_7, 0x7f, ALT_8,
 0x80, ALT_9, 0x81, ALT_0,

 /* Extended codes		 */
 0x85, KEY_F(41), 0x86, KEY_F(42), 0x87, KEY_F(43), 0x88, KEY_F(44),
 0x89, KEY_F(45), 0x8a, KEY_F(46), 0x8b, KEY_F(47), 0x8c, KEY_F(48),
 0x03, 0, /* NULL */
 0xff, PADSLASH,     0x0d, PADENTER,      0x0a, CTL_PADENTER,
 0xa6, ALT_PADENTER, 0x53, SHF_PADSTOP,   0xfc, CTL_ENTER,
 0xfa, PADSTAR,      0xfd, PADMINUS,      0xfb, PADPLUS,
 0x93, CTL_PADSTOP,  0x8f, CTL_PADCENTER, 0x90, CTL_PADPLUS,
 0x8e, CTL_PADMINUS, 0x95, CTL_PADSLASH,  0x96, CTL_PADSTAR,
 0x4e, ALT_PADPLUS,  0x4a, ALT_PADMINUS,  0xa4, ALT_PADSLASH,
 0x37, ALT_PADSTAR,  0x92, CTL_INS,       0xa2, ALT_INS,
 0xa3, ALT_DEL,      0x8d, CTL_UP,        0x91, CTL_DOWN,
 0x94, CTL_TAB,      0xa5, ALT_TAB,       0x82, ALT_MINUS,
 0x83, ALT_EQUAL,    0x99, ALT_PGUP,      0xa1, ALT_PGDN,
 0x9f, ALT_END,      0x98, ALT_UP,        0xa0, ALT_DOWN,
 0x9d, ALT_RIGHT,    0x9b, ALT_LEFT,      0x1c, ALT_ENTER,
 0x97, ALT_HOME,     0x01, ALT_ESC,       0x0e, ALT_BKSP,
 0x29, ALT_BQUOTE,   0x1a, ALT_LBRACKET,  0x1b, ALT_RBRACKET,
 0x27, ALT_SEMICOLON,0x28, ALT_FQUOTE,    0x33, ALT_COMMA,
 0x34, ALT_STOP,     0x35, ALT_FSLASH,    0x2b, ALT_BSLASH,

 /* Alt-Alphabet		 */
 0x1e, ALT_A, 0x30, ALT_B, 0x2e, ALT_C, 0x20, ALT_D,
 0x12, ALT_E, 0x21, ALT_F, 0x22, ALT_G, 0x23, ALT_H,
 0x17, ALT_I, 0x24, ALT_J, 0x25, ALT_K, 0x26, ALT_L,
 0x32, ALT_M, 0x31, ALT_N, 0x18, ALT_O, 0x19, ALT_P,
 0x10, ALT_Q, 0x13, ALT_R, 0x1f, ALT_S, 0x14, ALT_T,
 0x16, ALT_U, 0x2f, ALT_V, 0x11, ALT_W, 0x2d, ALT_X,
 0x15, ALT_Y, 0x2c, ALT_Z,

 0x0f, KEY_BACKTAB,

 /* End of kptab[]		 */
 0x100, -1
};
#endif




#ifdef	FLEXOS
chtype	kptab[] =
{
 /* Normal Function Keys	 */
 0x1001, KEY_F(1), 0x1002, KEY_F(2), 0x1003, KEY_F(3), 0x1004, KEY_F(4),
 0x1005, KEY_F(5), 0x1006, KEY_F(6), 0x1007, KEY_F(7), 0x1008, KEY_F(8),
 0x1009, KEY_F(9), 0x100A, KEY_F(10),

 /* Normal Keypad		 */
 0x2018, KEY_HOME, 0x2010, KEY_UP, 0x2014, KEY_PPAGE,
 0x2012, KEY_LEFT, 0x2035, KEY_B2, 0x2013, KEY_RIGHT,
 0x2008, KEY_LL, 0x2011, KEY_DOWN, 0x2015, KEY_NPAGE,
 0x2009, KEY_IC, 0x200A, KEY_DC,

 /* Shft-Function Keys	 */
 0x1401, KEY_F(11), 0x1402, KEY_F(12), 0x1403, KEY_F(13), 0x1404, KEY_F(14),
 0x1405, KEY_F(15), 0x1406, KEY_F(16), 0x1407, KEY_F(17), 0x1408, KEY_F(18),
 0x1409, KEY_F(19), 0x140A, KEY_F(20),

 /* Ctl-Function Keys	 */
 0x1101, KEY_F(21), 0x1102, KEY_F(22), 0x1103, KEY_F(23), 0x1104, KEY_F(24),
 0x1105, KEY_F(25), 0x1106, KEY_F(26), 0x1107, KEY_F(27), 0x1108, KEY_F(28),
 0x1109, KEY_F(29), 0x110A, KEY_F(30),

 /* Alt-Function Keys	 */
 0x1201, KEY_F(31), 0x1202, KEY_F(32), 0x1203, KEY_F(33), 0x1204, KEY_F(34),
 0x1205, KEY_F(35), 0x1206, KEY_F(36), 0x1207, KEY_F(37), 0x1208, KEY_F(38),
 0x1209, KEY_F(39), 0x120A, KEY_F(40),

 /* Control-Keypad		 */
 0x2118, CTL_HOME, 0x2114, CTL_PGUP,
 0x2112, CTL_LEFT, 0x2113, CTL_RIGHT,
 0x2108, CTL_END, 0x2115, CTL_PGDN,

 /* Alt-Numbers		 */
 0x2231, ALT_1, 0x2232, ALT_2, 0x2233, ALT_3, 0x2234, ALT_4,
 0x2235, ALT_5, 0x2236, ALT_6, 0x2237, ALT_7, 0x2238, ALT_8,
 0x2239, ALT_9, 0x2230, ALT_0,

 /* Alt-Alphabet		 */
 0x0200 | (unsigned) 'A', ALT_A, 0x0200 | (unsigned) 'B', ALT_B,
 0x0200 | (unsigned) 'C', ALT_C, 0x0200 | (unsigned) 'D', ALT_D,
 0x0200 | (unsigned) 'E', ALT_E, 0x0200 | (unsigned) 'F', ALT_F,
 0x0200 | (unsigned) 'G', ALT_G, 0x0200 | (unsigned) 'H', ALT_H,
 0x0200 | (unsigned) 'I', ALT_I, 0x0200 | (unsigned) 'J', ALT_J,
 0x0200 | (unsigned) 'K', ALT_K, 0x0200 | (unsigned) 'L', ALT_L,
 0x0200 | (unsigned) 'M', ALT_M, 0x0200 | (unsigned) 'N', ALT_N,
 0x0200 | (unsigned) 'O', ALT_O, 0x0200 | (unsigned) 'P', ALT_P,
 0x0200 | (unsigned) 'Q', ALT_Q, 0x0200 | (unsigned) 'R', ALT_R,
 0x0200 | (unsigned) 'S', ALT_S, 0x0200 | (unsigned) 'T', ALT_T,
 0x0200 | (unsigned) 'U', ALT_U, 0x0200 | (unsigned) 'V', ALT_V,
 0x0200 | (unsigned) 'W', ALT_W, 0x0200 | (unsigned) 'X', ALT_X,
 0x0200 | (unsigned) 'Y', ALT_Y, 0x0200 | (unsigned) 'Z', ALT_Z,

 0x0200 | (unsigned) 'a', ALT_A, 0x0200 | (unsigned) 'b', ALT_B,
 0x0200 | (unsigned) 'c', ALT_C, 0x0200 | (unsigned) 'd', ALT_D,
 0x0200 | (unsigned) 'e', ALT_E, 0x0200 | (unsigned) 'f', ALT_F,
 0x0200 | (unsigned) 'g', ALT_G, 0x0200 | (unsigned) 'h', ALT_H,
 0x0200 | (unsigned) 'i', ALT_I, 0x0200 | (unsigned) 'j', ALT_J,
 0x0200 | (unsigned) 'k', ALT_K, 0x0200 | (unsigned) 'l', ALT_L,
 0x0200 | (unsigned) 'm', ALT_M, 0x0200 | (unsigned) 'n', ALT_N,
 0x0200 | (unsigned) 'o', ALT_O, 0x0200 | (unsigned) 'p', ALT_P,
 0x0200 | (unsigned) 'q', ALT_Q, 0x0200 | (unsigned) 'r', ALT_R,
 0x0200 | (unsigned) 's', ALT_S, 0x0200 | (unsigned) 't', ALT_T,
 0x0200 | (unsigned) 'u', ALT_U, 0x0200 | (unsigned) 'v', ALT_V,
 0x0200 | (unsigned) 'w', ALT_W, 0x0200 | (unsigned) 'x', ALT_X,
 0x0200 | (unsigned) 'y', ALT_Y, 0x0200 | (unsigned) 'z', ALT_Z,

 0x0f, KEY_BACKTAB,

 /* End of kptab[]		 */
 0x100, -1
};
#endif




/*----------------------------------------------------------------------
$ PDC_validchar()	- validate/translate passed character
$
$ PDCurses Description:
$	This is a private PDCurses function.
$
$	Checks that 'c' is a valid character, and if so returns it,
$	with function key translation applied if 'w' has keypad mode
$	set.  If char is invalid, returns -1.
$
$ PDCurses Return Value:
$	This function returns -1 if the passed character is invalid, or
$	the WINDOW* 'w' is NULL, or 'w's keypad is not active.
$
$	This function returns 0 under Flexos if the passed character
$	is 0x0300.  (-:Forget why.  --Frotz	911130:-)
$
$	Otherwise, this function returns the PDCurses equivalent of the
$	passed character.  See the function key and key macros in
$	<curses.h>
$
$ PDCurses Errors:
$	There are no errors defined for this routine.
$
$ Portability:
$	PDCurses	chtype	PDC_validchar( chtype c );
$
$----------------------------------------------------------------------
*/
chtype	PDC_validchar(chtype c)
{
extern	WINDOW*	_getch_win_;
/* extern	WINDOW*	w;*/   /* w defined in wgetch() as static - _getch_win_ */
                        /* is the same window - all references to w changed*/
                        /* to _getch_win_ - marked with @@ */

	chtype    *scanp;

	if (_getch_win_ == (WINDOW *)NULL)
		return (-1);	/* bad window pointer	  */

#ifdef	FLEXOS
	if (c == 0x0300)
		return (0);	/* special case, ^@ = NULL	  */
#endif
	if (!(c & ~A_CHARTEXT))	return (c);  /* normal character */
	if (!(_getch_win_->_use_keypad))	return (-1); /* skip if keys if !keypad mode */

#if	defined (DOS) || defined (OS2)
	/*
	* Under DOS, extended keys are in the upper byte.  Shift down for a
	* comparison.
	*/
	c = (c >> 8) & A_CHARTEXT;
#endif
	scanp = kptab;
	while (*scanp > 0)	/* search for value		 */
	{			/* (stops on table entry 0x100) */
		if (*scanp++ == c)
		{
			return (*scanp);	/* found, return it */
		}
		scanp++;
	}
	return( -1 );		/* not found, invalid */
}
